/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.RemoteObject;
import io.requery.CascadeAction;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Index;
import io.requery.JunctionTable;
import io.requery.Key;
import io.requery.ManyToMany;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractQuota
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    public String event_slug;
    @Index
    public Long subevent_id;
    @Column(definition="TEXT")
    public String json_data;
    @ManyToMany(cascade={CascadeAction.NONE})
    @JunctionTable
    List<Item> items;
    @Column(nullable=true)
    public Long size;
    @Column(nullable=true)
    public Long available;
    @Column(nullable=true)
    public Long available_number;

    public boolean isUnlimited() {
        try {
            return this.getJSON().isNull("size");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean appliesToVariation(ItemVariation var) {
        try {
            return AbstractQuota.appliesToVariation(this.getJSON(), var);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public static boolean appliesToVariation(JSONObject quotaJson, Long varId) {
        try {
            JSONArray ja = quotaJson.getJSONArray("variations");
            for (int i2 = 0; i2 < ja.length(); ++i2) {
                if (ja.getLong(i2) != varId.longValue()) continue;
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean appliesToVariation(JSONObject quotaJson, ItemVariation var) {
        return AbstractQuota.appliesToVariation(quotaJson, var.getServer_id());
    }
}

