/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.PersistenceException;
import io.requery.sql.Platform;
import io.requery.sql.platform.Derby;
import io.requery.sql.platform.Generic;
import io.requery.sql.platform.H2;
import io.requery.sql.platform.HSQL;
import io.requery.sql.platform.MySQL;
import io.requery.sql.platform.Oracle;
import io.requery.sql.platform.PostgresSQL;
import io.requery.sql.platform.SQLServer;
import io.requery.sql.platform.SQLite;
import io.requery.util.function.Function;
import java.sql.Connection;
import java.sql.SQLException;

class PlatformFromConnection
implements Function<Connection, Platform> {
    PlatformFromConnection() {
    }

    @Override
    public Platform apply(Connection connection) {
        String product;
        try {
            product = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        Generic platform = product.contains("PostgreSQL") ? new PostgresSQL() : (product.contains("SQLite") ? new SQLite() : (product.contains("MySQL") ? new MySQL() : (product.contains("H2") ? new H2() : (product.contains("HSQL Database Engine") ? new HSQL() : (product.contains("Apache Derby") ? new Derby() : (product.contains("Oracle") ? new Oracle() : (product.contains("Microsoft SQL Server") ? new SQLServer() : new Generic())))))));
        return platform;
    }
}

