/*
 * Decompiled with CFR 0.152.
 */
package java8.lang;

public final class Longs {
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return q + ((r | r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
        }
        return (dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Longs.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return r - ((r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >> 63 & divisor);
        }
        return dividend - ((dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >> 63 & divisor);
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    private Longs() {
    }
}

