/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.Expression;
import io.requery.query.element.SelectionElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import java.util.Set;

class SelectGenerator
implements Generator<SelectionElement> {
    SelectGenerator() {
    }

    @Override
    public void write(final Output output, SelectionElement query) {
        Set<Expression<?>> selection;
        QueryBuilder qb = output.builder();
        qb.keyword(Keyword.SELECT);
        if (query.isDistinct()) {
            qb.keyword(Keyword.DISTINCT);
        }
        if ((selection = query.getSelection()) == null || selection.isEmpty()) {
            qb.append("*");
        } else {
            qb.commaSeparated(selection, new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    output.appendColumnForSelect(value);
                }
            });
        }
        qb.keyword(Keyword.FROM);
        output.appendTables();
    }
}

