/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.Return;
import io.requery.query.element.ExistsElement;
import io.requery.query.element.QueryWrapper;
import io.requery.query.element.WhereConditionElement;
import io.requery.query.element.WhereElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;

class WhereGenerator
implements Generator<WhereElement> {
    WhereGenerator() {
    }

    @Override
    public void write(Output output, WhereElement query) {
        QueryBuilder qb = output.builder();
        ExistsElement<?> whereExists = query.getWhereExistsElement();
        if (whereExists != null) {
            qb.keyword(Keyword.WHERE);
            if (whereExists.isNotExists()) {
                qb.keyword(Keyword.NOT);
            }
            qb.keyword(Keyword.EXISTS);
            qb.openParenthesis();
            Return<?> wrapper = whereExists.getQuery();
            output.appendQuery((QueryWrapper)((Object)wrapper));
            qb.closeParenthesis().space();
        } else if (query.getWhereElements() != null && query.getWhereElements().size() > 0) {
            qb.keyword(Keyword.WHERE);
            for (WhereConditionElement<?> w : query.getWhereElements()) {
                output.appendConditional(w);
            }
        }
    }
}

