/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.pretix.libpretixsync.serialization.JSONArraySerializer;
import eu.pretix.libpretixsync.serialization.JSONObjectSerializer;
import eu.pretix.pretixscan.scanproxy.ConnectivityHelper;
import eu.pretix.pretixscan.scanproxy.DatabaseKt;
import eu.pretix.pretixscan.scanproxy.SyncKt;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import eu.pretix.pretixscan.scanproxy.endpoints.AddEvent;
import eu.pretix.pretixscan.scanproxy.endpoints.AdminAuth;
import eu.pretix.pretixscan.scanproxy.endpoints.BadgeItemEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.BadgeLayoutEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckInListEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.ConfigState;
import eu.pretix.pretixscan.scanproxy.endpoints.DeviceAuth;
import eu.pretix.pretixscan.scanproxy.endpoints.DownloadEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EmptyResourceEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EventEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EventRegister;
import eu.pretix.pretixscan.scanproxy.endpoints.EventsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.ItemEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.MultiCheckEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.MultiSearchEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.RemoveEvent;
import eu.pretix.pretixscan.scanproxy.endpoints.SearchEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SettingsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstream;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamInit;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamInitReady;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamRemove;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupUpstream;
import eu.pretix.pretixscan.scanproxy.endpoints.StatusEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SubEventEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SubEventsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SyncEventList;
import eu.pretix.pretixscan.scanproxy.endpoints.SyncNow;
import eu.pretix.pretixscan.scanproxy.endpoints.UpstreamVersion;
import io.javalin.Javalin;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.core.JavalinConfig;
import io.javalin.http.Context;
import io.javalin.plugin.json.JavalinJackson;
import io.requery.Persistable;
import io.requery.sql.EntityDataStore;
import io.requery.sql.KotlinEntityDataStore;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.harawata.appdirs.AppDirs;
import net.harawata.appdirs.AppDirsFactory;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$H\u0007\u00a2\u0006\u0002\u0010%R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Leu/pretix/pretixscan/scanproxy/Server;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "VERSION", "", "getVERSION", "()Ljava/lang/String;", "VERSION_CODE", "", "getVERSION_CODE", "()I", "appDirs", "Lnet/harawata/appdirs/AppDirs;", "getAppDirs", "()Lnet/harawata/appdirs/AppDirs;", "connectivityHelper", "Leu/pretix/pretixscan/scanproxy/ConnectivityHelper;", "getConnectivityHelper", "()Leu/pretix/pretixscan/scanproxy/ConnectivityHelper;", "dataDir", "getDataDir", "proxyData", "Lio/requery/sql/KotlinEntityDataStore;", "Lio/requery/Persistable;", "getProxyData", "()Lio/requery/sql/KotlinEntityDataStore;", "syncData", "Lio/requery/sql/EntityDataStore;", "getSyncData", "()Lio/requery/sql/EntityDataStore;", "main", "", "args", "", "([Ljava/lang/String;)V", "server"})
public final class Server {
    @NotNull
    public static final Server INSTANCE = new Server();
    @NotNull
    private static final String VERSION = "2.4.0";
    private static final int VERSION_CODE = 13;
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    @NotNull
    private static final EntityDataStore<Persistable> syncData = DatabaseKt.makeSyncDataStore();
    @NotNull
    private static final KotlinEntityDataStore<Persistable> proxyData = DatabaseKt.makeProxyDataStore();
    @NotNull
    private static final ConnectivityHelper connectivityHelper;
    @NotNull
    private static final AppDirs appDirs;
    private static final String dataDir;

    private Server() {
    }

    @NotNull
    public final String getVERSION() {
        return VERSION;
    }

    public final int getVERSION_CODE() {
        return VERSION_CODE;
    }

    @NotNull
    public final EntityDataStore<Persistable> getSyncData() {
        return syncData;
    }

    @NotNull
    public final KotlinEntityDataStore<Persistable> getProxyData() {
        return proxyData;
    }

    @NotNull
    public final ConnectivityHelper getConnectivityHelper() {
        return connectivityHelper;
    }

    @NotNull
    public final AppDirs getAppDirs() {
        return appDirs;
    }

    public final String getDataDir() {
        return dataDir;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Javalin app = Javalin.create(Server::main$lambda-1);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, new JSONObjectSerializer(null, 1, null));
        module.addSerializer(JSONArray.class, new JSONArraySerializer(null, 1, null));
        JavalinJackson.getObjectMapper().registerModule(module);
        JavalinJackson.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        app.routes(Server::main$lambda-10);
        Thread webthread = new Thread(() -> Server.main$lambda-11(app));
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        Runnable periodicTask = Server::main$lambda-12;
        executor.scheduleWithFixedDelay(periodicTask, 0L, 10L, TimeUnit.SECONDS);
        webthread.start();
    }

    private static final void main$lambda-1$lambda-0(Context ctx, Float executionTimeMs) {
        String string;
        String string2;
        DownstreamDeviceEntity device;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(executionTimeMs, "executionTimeMs");
        DownstreamDeviceEntity downstreamDeviceEntity = device = (DownstreamDeviceEntity)ctx.attribute("device");
        String device_name = string2 = downstreamDeviceEntity == null ? "" : ((string = downstreamDeviceEntity.getName()) == null ? "" : string);
        LOG.info('[' + ctx.ip() + "] '" + device_name + "' " + ctx.method() + ' ' + ctx.path() + " -> " + ctx.status());
    }

    private static final void main$lambda-1(JavalinConfig config) {
        config.requestLogger(Server::main$lambda-1$lambda-0);
        config.prefer405over404 = true;
        config.addStaticFiles("/public");
    }

    private static final void main$lambda-10$lambda-5$lambda-4$lambda-3$lambda-2() {
        ApiBuilder.before(EventRegister.INSTANCE);
        ApiBuilder.get(EventEndpoint.INSTANCE);
        ApiBuilder.get("categories/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("items/", ItemEndpoint.INSTANCE);
        ApiBuilder.get("questions/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("badgelayouts/", BadgeLayoutEndpoint.INSTANCE);
        ApiBuilder.get("checkinlists/", CheckInListEndpoint.INSTANCE);
        ApiBuilder.get("orders/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("badgeitems/", BadgeItemEndpoint.INSTANCE);
        ApiBuilder.get("settings/", SettingsEndpoint.INSTANCE);
        ApiBuilder.get("revokedsecrets/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("subevents/:id/", SubEventEndpoint.INSTANCE);
    }

    private static final void main$lambda-10$lambda-5$lambda-4$lambda-3() {
        ApiBuilder.get(EventsEndpoint.INSTANCE);
        ApiBuilder.path(":event", Server::main$lambda-10$lambda-5$lambda-4$lambda-3$lambda-2);
    }

    private static final void main$lambda-10$lambda-5$lambda-4() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get("subevents", SubEventsEndpoint.INSTANCE);
        ApiBuilder.path("events", Server::main$lambda-10$lambda-5$lambda-4$lambda-3);
    }

    private static final void main$lambda-10$lambda-5() {
        ApiBuilder.get("version", UpstreamVersion.INSTANCE);
        ApiBuilder.post("device/initialize", SetupDownstream.INSTANCE);
        ApiBuilder.path("organizers/:organizer", Server::main$lambda-10$lambda-5$lambda-4);
    }

    private static final void main$lambda-10$lambda-8$lambda-6() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get("status/", StatusEndpoint.INSTANCE);
        ApiBuilder.post("search/", SearchEndpoint.INSTANCE);
        ApiBuilder.post("check/", CheckEndpoint.INSTANCE);
    }

    private static final void main$lambda-10$lambda-8$lambda-7() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.post("search/", MultiSearchEndpoint.INSTANCE);
        ApiBuilder.post("check/", MultiCheckEndpoint.INSTANCE);
    }

    private static final void main$lambda-10$lambda-8() {
        ApiBuilder.before("configure", AdminAuth.INSTANCE);
        ApiBuilder.post("configure", SetupUpstream.INSTANCE);
        ApiBuilder.before("state", AdminAuth.INSTANCE);
        ApiBuilder.get("state", ConfigState.INSTANCE);
        ApiBuilder.before("removeevent", AdminAuth.INSTANCE);
        ApiBuilder.post("removeevent", RemoveEvent.INSTANCE);
        ApiBuilder.before("addevent", AdminAuth.INSTANCE);
        ApiBuilder.post("addevent", AddEvent.INSTANCE);
        ApiBuilder.before("init", AdminAuth.INSTANCE);
        ApiBuilder.post("init", SetupDownstreamInit.INSTANCE);
        ApiBuilder.before("initready", AdminAuth.INSTANCE);
        ApiBuilder.post("initready", SetupDownstreamInitReady.INSTANCE);
        ApiBuilder.before("remove", AdminAuth.INSTANCE);
        ApiBuilder.post("remove", SetupDownstreamRemove.INSTANCE);
        ApiBuilder.before("sync", AdminAuth.INSTANCE);
        ApiBuilder.post("sync", SyncNow.INSTANCE);
        ApiBuilder.before("synceventlist", AdminAuth.INSTANCE);
        ApiBuilder.post("synceventlist", SyncEventList.INSTANCE);
        ApiBuilder.path("rpc/:event/:list/", Server::main$lambda-10$lambda-8$lambda-6);
        ApiBuilder.path("rpc/", Server::main$lambda-10$lambda-8$lambda-7);
    }

    private static final void main$lambda-10$lambda-9() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get(":filename", DownloadEndpoint.INSTANCE);
    }

    private static final void main$lambda-10() {
        ApiBuilder.path("api/v1", Server::main$lambda-10$lambda-5);
        ApiBuilder.before("/", AdminAuth.INSTANCE);
        ApiBuilder.path("proxyapi/v1/", Server::main$lambda-10$lambda-8);
        ApiBuilder.path("download", Server::main$lambda-10$lambda-9);
    }

    private static final void main$lambda-11(Javalin $app) {
        $app.start(7000);
    }

    private static final void main$lambda-12() {
        try {
            SyncKt.syncAllEvents$default(false, 1, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        String string = System.getProperty("pretixscan.autoOfflineMode", "off");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"pretixscan.autoOfflineMode\", \"off\")");
        connectivityHelper = new ConnectivityHelper(string);
        AppDirs appDirs = AppDirsFactory.getInstance();
        Intrinsics.checkNotNull(appDirs);
        Server.appDirs = appDirs;
        dataDir = Server.appDirs.getUserDataDir("pretixscanproxy", "1", "pretix");
    }
}

