/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy.endpoints;

import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.OnlineCheckProvider;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.pretixscan.scanproxy.Server;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckInput;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckInputAnswer;
import eu.pretix.pretixscan.scanproxy.endpoints.JsonBodyHandler;
import eu.pretix.pretixscan.scanproxy.endpoints.RpcKt;
import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Leu/pretix/pretixscan/scanproxy/endpoints/CheckEndpoint;", "Leu/pretix/pretixscan/scanproxy/endpoints/JsonBodyHandler;", "Leu/pretix/pretixscan/scanproxy/endpoints/CheckInput;", "()V", "handle", "", "ctx", "Lio/javalin/http/Context;", "body", "server"})
public final class CheckEndpoint
extends JsonBodyHandler<CheckInput> {
    @NotNull
    public static final CheckEndpoint INSTANCE = new CheckEndpoint();

    private CheckEndpoint() {
        super(CheckInput.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(@NotNull Context ctx, @NotNull CheckInput body2) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(body2, "body");
        Logger LOG = LoggerFactory.getLogger("eu.pretix.pretixscan.scanproxy.endpoints.CheckEndpoint");
        TicketCheckProvider acp = RpcKt.getCheckProvider();
        long startedAt = System.currentTimeMillis();
        try {
            Iterable destination$iv$iv;
            Object object;
            Object object2;
            Iterable<Answer> iterable;
            String string = body2.getType();
            string = string == null ? "entry" : string;
            boolean bl = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).toUpperCase()");
            TicketCheckProvider.CheckInType type2 = TicketCheckProvider.CheckInType.valueOf(string2);
            TicketCheckProvider ticketCheckProvider = acp;
            Object object3 = ctx.pathParam("list");
            boolean bl2 = false;
            Map<String, Long> map = MapsKt.mapOf(TuplesKt.to(ctx.pathParam("event"), Long.parseLong((String)object3)));
            String string3 = body2.getTicketid();
            object3 = body2.getSource_type();
            Object object4 = object3 == null ? "barcode" : object3;
            object3 = body2.getAnswers();
            if (object3 == null) {
                iterable = null;
            } else {
                Iterable<Answer> iterable2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable3 = (Iterable)object3;
                String string4 = object4;
                String string5 = string3;
                object2 = map;
                object = ticketCheckProvider;
                boolean $i$f$map = false;
                void var12_21 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CheckInputAnswer checkInputAnswer = (CheckInputAnswer)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl3 = false;
                    Answer answer = it.toAnswer();
                    iterable2.add(answer);
                }
                iterable2 = (List)destination$iv$iv;
                ticketCheckProvider = object;
                map = object2;
                string3 = string5;
                object4 = string4;
                iterable = iterable2;
            }
            TicketCheckProvider.CheckResult result2 = TicketCheckProvider.DefaultImpls.check$default(ticketCheckProvider, map, string3, (String)object4, iterable, body2.getIgnore_unpaid(), body2.getWith_badge_data(), type2, null, 128, null);
            List<TicketCheckProvider.QuestionAnswer> requiredAnswers = result2.getRequiredAnswers();
            if (requiredAnswers != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = requiredAnswers;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TicketCheckProvider.QuestionAnswer bl3 = (TicketCheckProvider.QuestionAnswer)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl4 = false;
                    object2 = it.getQuestion();
                    object.add(object2);
                }
                List questions = (List)destination$iv$iv2;
                for (Question q : questions) {
                    q.resolveDependency(questions);
                }
            }
            Object t = ctx.attribute("device");
            Intrinsics.checkNotNull(t);
            DownstreamDeviceEntity device = (DownstreamDeviceEntity)t;
            LOG.info("Scanned ticket '" + body2.getTicketid() + "' result '" + (Object)((Object)result2.getType()) + "' time '" + (float)(System.currentTimeMillis() - startedAt) / 1000.0f + "s' device '" + device.getName() + "' provider '" + acp.getClass().getSimpleName() + '\'');
            ctx.json(result2);
            if (acp instanceof OnlineCheckProvider) {
                if (result2.getType() == TicketCheckProvider.CheckResult.Type.ERROR) {
                    Server.INSTANCE.getConnectivityHelper().recordError();
                } else {
                    Server.INSTANCE.getConnectivityHelper().recordSuccess(System.currentTimeMillis() - startedAt);
                }
            }
        }
        catch (CheckException e) {
            Server.INSTANCE.getConnectivityHelper().recordError();
            ctx.status(400).json(MapsKt.mapOf(TuplesKt.to("title", e.getMessage())));
        }
    }
}

