/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.RemoteObject;
import io.requery.Column;
import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Generated;
import io.requery.Index;
import io.requery.Key;
import io.requery.ManyToOne;
import io.requery.Nullable;
import io.requery.ReferentialAction;
import java.util.Date;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractCheckIn
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    @Column
    @Index
    public Long listId;
    @Nullable
    @Index
    public Long server_id;
    public Date datetime;
    @Column
    @ForeignKey(update=ReferentialAction.CASCADE)
    @ManyToOne
    @Index
    public OrderPosition position;
    @Column(definition="TEXT")
    public String json_data;
    @Column
    public String type;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public String getType() {
        try {
            return this.getJSON().getString("type");
        }
        catch (JSONException e) {
            return "entry";
        }
    }

    public Date getFullDatetime() {
        try {
            return ISODateTimeFormat.dateTimeParser().parseDateTime(this.getJSON().getString("datetime")).toDate();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.datetime;
        }
    }
}

