/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.Converter;
import io.requery.converter.CurrencyConverter;
import io.requery.converter.EnumStringConverter;
import io.requery.converter.LocalDateConverter;
import io.requery.converter.LocalDateTimeConverter;
import io.requery.converter.LocalTimeConverter;
import io.requery.converter.OffsetDateTimeConverter;
import io.requery.converter.URIConverter;
import io.requery.converter.URLConverter;
import io.requery.converter.UUIDConverter;
import io.requery.converter.ZonedDateTimeConverter;
import io.requery.meta.Attribute;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.function.Function;
import io.requery.sql.FieldType;
import io.requery.sql.Mapping;
import io.requery.sql.type.BigIntType;
import io.requery.sql.type.BinaryType;
import io.requery.sql.type.BlobType;
import io.requery.sql.type.BooleanType;
import io.requery.sql.type.ClobType;
import io.requery.sql.type.DateType;
import io.requery.sql.type.DecimalType;
import io.requery.sql.type.FloatType;
import io.requery.sql.type.IntegerType;
import io.requery.sql.type.JavaDateType;
import io.requery.sql.type.PrimitiveBooleanType;
import io.requery.sql.type.PrimitiveByteType;
import io.requery.sql.type.PrimitiveDoubleType;
import io.requery.sql.type.PrimitiveFloatType;
import io.requery.sql.type.PrimitiveIntType;
import io.requery.sql.type.PrimitiveLongType;
import io.requery.sql.type.PrimitiveShortType;
import io.requery.sql.type.RealType;
import io.requery.sql.type.SmallIntType;
import io.requery.sql.type.TimeStampType;
import io.requery.sql.type.TimeType;
import io.requery.sql.type.TinyIntType;
import io.requery.sql.type.VarBinaryType;
import io.requery.sql.type.VarCharType;
import io.requery.util.ClassMap;
import io.requery.util.LanguageVersion;
import io.requery.util.Objects;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GenericMapping
implements Mapping {
    private static final Comparator<Class<?>> CLASS_NAME_COMPARATOR = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final ClassMap<FieldType> types = new ClassMap();
    private final ClassMap<FieldType> fixedTypes;
    private final ClassMap<Converter<?, ?>> converters;
    private final Map<Attribute, FieldType> resolvedTypes;
    private final ClassMap<Function.Name> functionTypes;
    private PrimitiveIntType primitiveIntType = new IntegerType(Integer.TYPE);
    private PrimitiveLongType primitiveLongType = new BigIntType(Long.TYPE);
    private PrimitiveShortType primitiveShortType = new SmallIntType(Short.TYPE);
    private PrimitiveByteType primitiveByteType;
    private PrimitiveBooleanType primitiveBooleanType = new BooleanType(Boolean.TYPE);
    private PrimitiveFloatType primitiveFloatType = new FloatType(Float.TYPE);
    private PrimitiveDoubleType primitiveDoubleType = new RealType(Double.TYPE);

    public GenericMapping() {
        this.primitiveByteType = new TinyIntType(Byte.TYPE);
        this.types.put(Boolean.TYPE, (FieldType)new BooleanType(Boolean.TYPE));
        this.types.put(Boolean.class, (FieldType)new BooleanType(Boolean.class));
        this.types.put(Integer.TYPE, (FieldType)new IntegerType(Integer.TYPE));
        this.types.put(Integer.class, (FieldType)new IntegerType(Integer.class));
        this.types.put(Short.TYPE, (FieldType)new SmallIntType(Short.TYPE));
        this.types.put(Short.class, (FieldType)new SmallIntType(Short.class));
        this.types.put(Byte.TYPE, (FieldType)new TinyIntType(Byte.TYPE));
        this.types.put(Byte.class, (FieldType)new TinyIntType(Byte.class));
        this.types.put(Long.TYPE, (FieldType)new BigIntType(Long.TYPE));
        this.types.put(Long.class, (FieldType)new BigIntType(Long.class));
        this.types.put(Float.TYPE, (FieldType)new FloatType(Float.TYPE));
        this.types.put(Float.class, (FieldType)new FloatType(Float.class));
        this.types.put(Double.TYPE, (FieldType)new RealType(Double.TYPE));
        this.types.put(Double.class, (FieldType)new RealType(Double.class));
        this.types.put(BigDecimal.class, (FieldType)new DecimalType());
        this.types.put(byte[].class, (FieldType)new VarBinaryType());
        this.types.put(java.util.Date.class, (FieldType)new JavaDateType());
        this.types.put(Date.class, (FieldType)new DateType());
        this.types.put(Time.class, (FieldType)new TimeType());
        this.types.put(Timestamp.class, (FieldType)new TimeStampType());
        this.types.put(String.class, (FieldType)new VarCharType());
        this.types.put(Blob.class, (FieldType)new BlobType());
        this.types.put(Clob.class, (FieldType)new ClobType());
        this.fixedTypes = new ClassMap();
        this.fixedTypes.put(byte[].class, (FieldType)new BinaryType());
        this.functionTypes = new ClassMap();
        this.converters = new ClassMap();
        this.resolvedTypes = new IdentityHashMap<Attribute, FieldType>();
        HashSet converters2 = new HashSet();
        converters2.add(new EnumStringConverter<Enum>(Enum.class));
        converters2.add(new UUIDConverter());
        converters2.add(new URIConverter());
        converters2.add(new URLConverter());
        converters2.add(new CurrencyConverter());
        if (LanguageVersion.current().atLeast(LanguageVersion.JAVA_1_8)) {
            converters2.add(new LocalDateConverter());
            converters2.add(new LocalTimeConverter());
            converters2.add(new LocalDateTimeConverter());
            converters2.add(new ZonedDateTimeConverter());
            converters2.add(new OffsetDateTimeConverter());
        }
        for (Converter converter : converters2) {
            Class mapped = converter.getMappedType();
            if (this.types.containsKey(mapped)) continue;
            this.converters.put(mapped, converter);
        }
    }

    @Override
    public Mapping aliasFunction(Function.Name name, Class<? extends Function> function2) {
        this.functionTypes.put(function2, name);
        return this;
    }

    @Override
    public <T> Mapping replaceType(int sqlType, FieldType<T> replacementType) {
        Objects.requireNotNull(replacementType);
        this.replace(this.types, sqlType, replacementType);
        this.replace(this.fixedTypes, sqlType, replacementType);
        return this;
    }

    private void replace(ClassMap<FieldType> map, int sqlType, FieldType replace) {
        LinkedHashSet keys2 = new LinkedHashSet();
        for (Map.Entry<Class<?>, FieldType> entry : map.entrySet()) {
            if (entry.getValue().getSqlType() != sqlType) continue;
            keys2.add(entry.getKey());
        }
        for (Class clazz : keys2) {
            map.put(clazz, replace);
        }
        if (sqlType == this.primitiveIntType.getSqlType() && replace instanceof PrimitiveIntType) {
            this.primitiveIntType = (PrimitiveIntType)replace;
        } else if (sqlType == this.primitiveLongType.getSqlType() && replace instanceof PrimitiveLongType) {
            this.primitiveLongType = (PrimitiveLongType)replace;
        } else if (sqlType == this.primitiveShortType.getSqlType() && replace instanceof PrimitiveShortType) {
            this.primitiveShortType = (PrimitiveShortType)replace;
        } else if (sqlType == this.primitiveBooleanType.getSqlType() && replace instanceof PrimitiveBooleanType) {
            this.primitiveBooleanType = (PrimitiveBooleanType)replace;
        } else if (sqlType == this.primitiveFloatType.getSqlType() && replace instanceof PrimitiveFloatType) {
            this.primitiveFloatType = (PrimitiveFloatType)replace;
        } else if (sqlType == this.primitiveDoubleType.getSqlType() && replace instanceof PrimitiveDoubleType) {
            this.primitiveDoubleType = (PrimitiveDoubleType)replace;
        } else if (sqlType == this.primitiveByteType.getSqlType() && replace instanceof PrimitiveByteType) {
            this.primitiveByteType = (PrimitiveByteType)replace;
        }
    }

    @Override
    public <T> Mapping putType(Class<? super T> type2, FieldType<T> fieldType) {
        if (type2 == null) {
            throw new IllegalArgumentException();
        }
        if (fieldType == null) {
            throw new IllegalArgumentException();
        }
        this.types.put(type2, fieldType);
        return this;
    }

    Converter<?, ?> converterForType(Class<?> type2) {
        Converter<?, ?> converter = this.converters.get(type2);
        if (converter == null && type2.isEnum()) {
            converter = this.converters.get(Enum.class);
        }
        return converter;
    }

    @Override
    public FieldType mapAttribute(Attribute<?, ?> attribute) {
        FieldType fieldType = this.resolvedTypes.get(attribute);
        if (fieldType != null) {
            return fieldType;
        }
        Class<Object> type2 = attribute.getClassType();
        if (attribute.isAssociation() && attribute.getReferencedAttribute() != null) {
            type2 = attribute.getReferencedAttribute().get().getClassType();
        }
        if (attribute.getConverter() != null) {
            Converter<?, ?> converter = attribute.getConverter();
            type2 = converter.getPersistedType();
        }
        fieldType = this.getSubstitutedType(type2);
        this.resolvedTypes.put(attribute, fieldType);
        return fieldType;
    }

    @Override
    public Function.Name mapFunctionName(Function<?> function2) {
        Function.Name name = this.functionTypes.get(function2.getClass());
        return name != null ? name : function2.getFunctionName();
    }

    @Override
    public Set<Class<?>> typesOf(int sqlType) {
        TreeSet types = new TreeSet(CLASS_NAME_COMPARATOR);
        for (Map.Entry<Class<?>, FieldType> entry : this.types.entrySet()) {
            if (entry.getValue().getSqlType() != sqlType) continue;
            types.add(entry.getKey());
        }
        if (types.isEmpty()) {
            types.add(String.class);
        }
        return types;
    }

    private FieldType getSubstitutedType(Class<?> type2) {
        FieldType<String> fieldType = null;
        Converter<?, ?> converter = this.converterForType(type2);
        if (converter != null) {
            if (converter.getPersistedSize() != null) {
                fieldType = this.fixedTypes.get(converter.getPersistedType());
            }
            type2 = converter.getPersistedType();
        }
        if (fieldType == null) {
            fieldType = this.types.get(type2);
        }
        return fieldType == null ? new VarCharType() : fieldType;
    }

    @Override
    public <A> A read(Expression<A> expression, ResultSet results, int column) throws SQLException {
        FieldType fieldType;
        Class<Object> type2;
        Attribute attribute;
        Converter<Object, ?> converter = null;
        if (expression.getExpressionType() == ExpressionType.ATTRIBUTE) {
            attribute = (Attribute)((Object)expression);
            converter = attribute.getConverter();
            type2 = attribute.getClassType();
            fieldType = this.mapAttribute(attribute);
        } else if (expression.getExpressionType() == ExpressionType.ALIAS) {
            attribute = (Attribute)((Object)expression.getInnerExpression());
            converter = attribute.getConverter();
            type2 = attribute.getClassType();
            fieldType = this.mapAttribute(attribute);
        } else {
            type2 = expression.getClassType();
            fieldType = this.getSubstitutedType(type2);
        }
        boolean isPrimitive = type2.isPrimitive();
        if (converter == null && !isPrimitive) {
            converter = this.converterForType(type2);
        }
        Object value = fieldType.read(results, column);
        if (isPrimitive && results.wasNull()) {
            value = null;
        }
        if (converter != null) {
            value = GenericMapping.toMapped(converter, type2, value);
        }
        if (isPrimitive) {
            Object boxed = value;
            return (A)boxed;
        }
        return (A)type2.cast(value);
    }

    @Override
    public boolean readBoolean(ResultSet results, int column) throws SQLException {
        return this.primitiveBooleanType.readBoolean(results, column);
    }

    @Override
    public byte readByte(ResultSet results, int column) throws SQLException {
        return this.primitiveByteType.readByte(results, column);
    }

    @Override
    public short readShort(ResultSet results, int column) throws SQLException {
        return this.primitiveShortType.readShort(results, column);
    }

    @Override
    public int readInt(ResultSet results, int column) throws SQLException {
        return this.primitiveIntType.readInt(results, column);
    }

    @Override
    public long readLong(ResultSet results, int column) throws SQLException {
        return this.primitiveLongType.readLong(results, column);
    }

    @Override
    public float readFloat(ResultSet results, int column) throws SQLException {
        return this.primitiveFloatType.readFloat(results, column);
    }

    @Override
    public double readDouble(ResultSet results, int column) throws SQLException {
        return this.primitiveDoubleType.readDouble(results, column);
    }

    @Override
    public <A> void write(Expression<A> expression, PreparedStatement statement, int index, A value) throws SQLException {
        Class<Object> type2;
        FieldType fieldType;
        Converter<Object, ?> converter = null;
        if (expression.getExpressionType() == ExpressionType.ATTRIBUTE) {
            Attribute attribute = (Attribute)((Object)expression);
            converter = attribute.getConverter();
            fieldType = this.mapAttribute(attribute);
            type2 = attribute.isAssociation() ? attribute.getReferencedAttribute().get().getClassType() : attribute.getClassType();
        } else {
            type2 = expression.getClassType();
            fieldType = this.getSubstitutedType(type2);
        }
        if (converter == null && !type2.isPrimitive()) {
            converter = this.converterForType(type2);
        }
        Object converted = value;
        if (converter != null) {
            converted = converter.convertToPersisted(value);
        }
        fieldType.write(statement, index, converted);
    }

    @Override
    public void writeBoolean(PreparedStatement statement, int index, boolean value) throws SQLException {
        this.primitiveBooleanType.writeBoolean(statement, index, value);
    }

    @Override
    public void writeByte(PreparedStatement statement, int index, byte value) throws SQLException {
        this.primitiveByteType.writeByte(statement, index, value);
    }

    @Override
    public void writeShort(PreparedStatement statement, int index, short value) throws SQLException {
        this.primitiveShortType.writeShort(statement, index, value);
    }

    @Override
    public void writeInt(PreparedStatement statement, int index, int value) throws SQLException {
        this.primitiveIntType.writeInt(statement, index, value);
    }

    @Override
    public void writeLong(PreparedStatement statement, int index, long value) throws SQLException {
        this.primitiveLongType.writeLong(statement, index, value);
    }

    @Override
    public void writeFloat(PreparedStatement statement, int index, float value) throws SQLException {
        this.primitiveFloatType.writeFloat(statement, index, value);
    }

    @Override
    public void writeDouble(PreparedStatement statement, int index, double value) throws SQLException {
        this.primitiveDoubleType.writeDouble(statement, index, value);
    }

    public void addConverter(Converter<?, ?> converter, Class<?> ... classes2) {
        this.converters.put(converter.getMappedType(), converter);
        for (Class<?> type2 : classes2) {
            this.converters.put(type2, converter);
        }
    }

    private static <A, B> A toMapped(Converter<A, B> converter, Class<? extends A> type2, B value) {
        return converter.convertToMapped(type2, value);
    }
}

