/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.Transaction;
import io.requery.TransactionException;
import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.EntityTransaction;
import io.requery.sql.TransactionEntitiesSet;
import io.requery.sql.UncloseableConnection;
import io.requery.util.Objects;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

class ManagedTransaction
implements EntityTransaction,
ConnectionProvider,
Synchronization {
    private final ConnectionProvider connectionProvider;
    private final TransactionListener transactionListener;
    private final TransactionEntitiesSet entities;
    private Connection connection;
    private Connection uncloseableConnection;
    private TransactionSynchronizationRegistry registry;
    private UserTransaction userTransaction;
    private boolean committed;
    private boolean rolledBack;
    private boolean initiatedTransaction;
    private boolean completed;

    ManagedTransaction(TransactionListener transactionListener, ConnectionProvider connectionProvider, EntityCache cache2) {
        this.transactionListener = Objects.requireNotNull(transactionListener);
        this.connectionProvider = Objects.requireNotNull(connectionProvider);
        this.entities = new TransactionEntitiesSet(cache2);
    }

    private TransactionSynchronizationRegistry getSynchronizationRegistry() {
        if (this.registry == null) {
            try {
                this.registry = (TransactionSynchronizationRegistry)InitialContext.doLookup("java:comp/TransactionSynchronizationRegistry");
            }
            catch (NamingException e) {
                throw new TransactionException(e);
            }
        }
        return this.registry;
    }

    private UserTransaction getUserTransaction() {
        if (this.userTransaction == null) {
            try {
                this.userTransaction = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            }
            catch (NamingException e) {
                throw new TransactionException(e);
            }
        }
        return this.userTransaction;
    }

    @Override
    public Connection getConnection() {
        return this.uncloseableConnection;
    }

    @Override
    public Transaction begin() {
        if (this.active()) {
            throw new IllegalStateException("transaction already active");
        }
        this.transactionListener.beforeBegin(null);
        int status = this.getSynchronizationRegistry().getTransactionStatus();
        if (status == 6) {
            try {
                this.getUserTransaction().begin();
                this.initiatedTransaction = true;
            }
            catch (NotSupportedException | SystemException e) {
                throw new TransactionException(e);
            }
        }
        this.getSynchronizationRegistry().registerInterposedSynchronization((Synchronization)this);
        try {
            this.connection = this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
        this.uncloseableConnection = new UncloseableConnection(this.connection);
        this.committed = false;
        this.rolledBack = false;
        this.entities.clear();
        this.transactionListener.afterBegin(null);
        return this;
    }

    @Override
    public Transaction begin(TransactionIsolation isolation) {
        if (isolation != null) {
            throw new TransactionException("isolation can't be specified in managed mode");
        }
        return this.begin();
    }

    @Override
    public void close() {
        if (this.connection != null) {
            if (!this.committed && !this.rolledBack) {
                this.rollback();
            }
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public void commit() {
        if (this.initiatedTransaction) {
            try {
                this.transactionListener.beforeCommit(this.entities.types());
                this.getUserTransaction().commit();
                this.transactionListener.afterCommit(this.entities.types());
            }
            catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                throw new TransactionException(e);
            }
        }
        try {
            this.entities.clear();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void rollback() {
        if (!this.rolledBack) {
            try {
                if (!this.completed) {
                    this.transactionListener.beforeRollback(this.entities.types());
                    if (this.initiatedTransaction) {
                        try {
                            this.getUserTransaction().rollback();
                        }
                        catch (SystemException e) {
                            throw new TransactionException(e);
                        }
                    } else if (this.active()) {
                        this.getSynchronizationRegistry().setRollbackOnly();
                    }
                    this.transactionListener.afterRollback(this.entities.types());
                }
            }
            finally {
                this.rolledBack = true;
                this.entities.clearAndInvalidate();
            }
        }
    }

    @Override
    public boolean active() {
        TransactionSynchronizationRegistry registry = this.getSynchronizationRegistry();
        return registry != null && registry.getTransactionStatus() == 0;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 1: 
            case 4: 
            case 9: {
                this.rollback();
                this.close();
            }
        }
        this.completed = true;
    }

    @Override
    public void addToTransaction(EntityProxy<?> proxy) {
        this.entities.add(proxy);
    }

    @Override
    public void addToTransaction(Collection<Type<?>> types) {
        this.entities.types().addAll(types);
    }
}

