/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.meta.Type;
import io.requery.query.BaseScalar;
import io.requery.query.Scalar;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryOperation;
import io.requery.sql.BoundParameters;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.PreparedQueryOperation;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.sql.TransactionProvider;
import io.requery.sql.TransactionScope;
import io.requery.sql.gen.DefaultOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;

class UpdateOperation
extends PreparedQueryOperation
implements QueryOperation<Scalar<Integer>> {
    UpdateOperation(RuntimeConfiguration configuration) {
        super(configuration, null);
    }

    UpdateOperation(RuntimeConfiguration configuration, GeneratedResultReader resultReader) {
        super(configuration, resultReader);
    }

    @Override
    public Scalar<Integer> evaluate(final QueryElement<Scalar<Integer>> query) {
        return new BaseScalar<Integer>(this.configuration.getWriteExecutor()){

            @Override
            public Integer evaluate() {
                int result2;
                DefaultOutput output = new DefaultOutput(UpdateOperation.this.configuration, query);
                String sql = output.toSql();
                TransactionProvider transactionProvider = UpdateOperation.this.configuration.getTransactionProvider();
                Set<Type<?>> types = query.entityTypes();
                try (TransactionScope scope2 = new TransactionScope(transactionProvider, types);
                     Connection connection = UpdateOperation.this.configuration.getConnection();){
                    StatementListener listener = UpdateOperation.this.configuration.getStatementListener();
                    try (PreparedStatement statement = UpdateOperation.this.prepare(sql, connection);){
                        BoundParameters parameters2 = output.parameters();
                        UpdateOperation.this.mapParameters(statement, parameters2);
                        listener.beforeExecuteUpdate(statement, sql, parameters2);
                        result2 = statement.executeUpdate();
                        listener.afterExecuteUpdate(statement, result2);
                        UpdateOperation.this.readGeneratedKeys(0, statement);
                    }
                    scope2.commit();
                }
                catch (SQLException e) {
                    throw new StatementExecutionException(e, sql);
                }
                return result2;
            }
        };
    }
}

