/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpClient httpClient;
    private boolean shutdown;

    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        this.httpClient = channel.getHttpDestination().getHttpClient();
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            new HeadersCallback(exchange, content, callback).iterate();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            ByteBufferPool bufferPool = this.httpClient.getByteBufferPool();
            ByteBuffer chunk = null;
            block10: while (true) {
                ByteBuffer contentBuffer = content.getByteBuffer();
                boolean lastContent = content.isLast();
                HttpGenerator.Result result2 = this.generator.generateRequest(null, null, chunk, contentBuffer, lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated content ({} bytes) - {}/{}", new Object[]{contentBuffer == null ? -1 : contentBuffer.remaining(), result2, this.generator});
                }
                switch (result2) {
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        break;
                    }
                    case NEED_CHUNK_TRAILER: {
                        chunk = bufferPool.acquire(this.httpClient.getRequestBufferSize(), false);
                        break;
                    }
                    case FLUSH: {
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunk != null) {
                            endPoint.write(new ByteBufferRecyclerCallback(callback, bufferPool, new ByteBuffer[]{chunk}), chunk, contentBuffer);
                        } else {
                            endPoint.write(callback, contentBuffer);
                        }
                        return;
                    }
                    case SHUTDOWN_OUT: {
                        this.shutdownOutput();
                        break;
                    }
                    case CONTINUE: {
                        if (lastContent) continue block10;
                        callback.succeeded();
                        return;
                    }
                    case DONE: {
                        callback.succeeded();
                        return;
                    }
                    default: {
                        throw new IllegalStateException(result2.toString());
                    }
                }
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", this.getHttpExchange().getRequest());
        }
        this.shutdown = true;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class ByteBufferRecyclerCallback
    extends Callback.Nested {
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool pool, ByteBuffer ... buffers) {
            super(callback);
            this.pool = pool;
            this.buffers = buffers;
        }

        @Override
        public void succeeded() {
            for (ByteBuffer buffer : this.buffers) {
                assert (!buffer.hasRemaining());
                this.pool.release(buffer);
            }
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            for (ByteBuffer buffer : this.buffers) {
                this.pool.release(buffer);
            }
            super.failed(x);
        }
    }

    private class HeadersCallback
    extends IteratingCallback {
        private final HttpExchange exchange;
        private final Callback callback;
        private final MetaData.Request metaData;
        private ByteBuffer headerBuffer;
        private ByteBuffer chunkBuffer;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private boolean generated;

        public HeadersCallback(HttpExchange exchange, HttpContent content, Callback callback) {
            super(false);
            this.exchange = exchange;
            this.callback = callback;
            HttpRequest request = exchange.getRequest();
            ContentProvider requestContent = request.getContent();
            long contentLength = requestContent == null ? -1L : requestContent.getLength();
            String path = request.getPath();
            String query = request.getQuery();
            if (query != null) {
                path = path + "?" + query;
            }
            this.metaData = new MetaData.Request(request.getMethod(), new HttpURI(path), request.getVersion(), request.getHeaders(), contentLength);
            this.metaData.setTrailerSupplier(request.getTrailers());
            if (!HttpSenderOverHTTP.this.expects100Continue(request)) {
                content.advance();
                this.contentBuffer = content.getByteBuffer();
                this.lastContent = content.isLast();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result2;
            block10: while (true) {
                result2 = HttpSenderOverHTTP.this.generator.generateRequest(this.metaData, this.headerBuffer, this.chunkBuffer, this.contentBuffer, this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{}", new Object[]{this.headerBuffer == null ? -1 : this.headerBuffer.remaining(), this.chunkBuffer == null ? -1 : this.chunkBuffer.remaining(), this.contentBuffer == null ? -1 : this.contentBuffer.remaining(), result2, HttpSenderOverHTTP.this.generator});
                }
                switch (result2) {
                    case NEED_HEADER: {
                        this.headerBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case HEADER_OVERFLOW: {
                        HttpSenderOverHTTP.this.httpClient.getByteBufferPool().release(this.headerBuffer);
                        this.headerBuffer = null;
                        throw new BadMessageException(500, "Request header too large");
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(12, false);
                        continue block10;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (this.headerBuffer == null) {
                            this.headerBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.chunkBuffer == null) {
                            this.chunkBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.contentBuffer == null) {
                            this.contentBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        long bytes = this.headerBuffer.remaining() + this.chunkBuffer.remaining() + this.contentBuffer.remaining();
                        HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().addBytesOut(bytes);
                        endPoint.write(this, this.headerBuffer, this.chunkBuffer, this.contentBuffer);
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block10;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", this.exchange.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(result2.toString());
        }

        @Override
        public void succeeded() {
            this.release();
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.release();
            super.failed(x);
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            this.callback.succeeded();
        }

        @Override
        protected void onCompleteFailure(Throwable cause) {
            super.onCompleteFailure(cause);
            this.callback.failed(cause);
        }

        private void release() {
            ByteBufferPool bufferPool = HttpSenderOverHTTP.this.httpClient.getByteBufferPool();
            if (!BufferUtil.isTheEmptyBuffer(this.headerBuffer)) {
                bufferPool.release(this.headerBuffer);
            }
            this.headerBuffer = null;
            if (!BufferUtil.isTheEmptyBuffer(this.chunkBuffer)) {
                bufferPool.release(this.chunkBuffer);
            }
            this.chunkBuffer = null;
            this.contentBuffer = null;
        }
    }
}

