/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.meta.EntityModel;
import io.requery.sql.Configuration;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.EntityStateListener;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.StatementListener;
import io.requery.sql.TransactionMode;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;

final class ImmutableConfiguration
implements Configuration {
    private final Platform platform;
    private final EntityModel model;
    private final EntityCache cache;
    private final Mapping mapping;
    private final boolean useDefaultLogging;
    private final int statementCacheSize;
    private final int batchUpdateSize;
    private final boolean quoteTableNames;
    private final boolean quoteColumnNames;
    private final Function<String, String> tableTransformer;
    private final Function<String, String> columnTransformer;
    private final TransactionMode transactionMode;
    private final TransactionIsolation transactionIsolation;
    private final ConnectionProvider connectionProvider;
    private final Set<EntityStateListener> entityStateListeners;
    private final Set<StatementListener> statementListeners;
    private final Set<Supplier<TransactionListener>> transactionListenerFactories;
    private final Executor writeExecutor;

    ImmutableConfiguration(ConnectionProvider connectionProvider, Platform platform, EntityModel model, EntityCache cache2, Mapping mapping, boolean useDefaultLogging, int statementCacheSize, int batchUpdateSize, boolean quoteTableNames, boolean quoteColumnNames, Function<String, String> tableTransformer, Function<String, String> columnTransformer, Set<EntityStateListener> entityStateListeners, Set<StatementListener> statementListeners, TransactionMode transactionMode, TransactionIsolation transactionIsolation, Set<Supplier<TransactionListener>> transactionListenerFactories, Executor writeExecutor) {
        this.connectionProvider = connectionProvider;
        this.platform = platform;
        this.model = model;
        this.cache = cache2;
        this.mapping = mapping;
        this.useDefaultLogging = useDefaultLogging;
        this.statementCacheSize = statementCacheSize;
        this.batchUpdateSize = batchUpdateSize;
        this.quoteTableNames = quoteTableNames;
        this.quoteColumnNames = quoteColumnNames;
        this.tableTransformer = tableTransformer;
        this.columnTransformer = columnTransformer;
        this.transactionMode = transactionMode;
        this.entityStateListeners = Collections.unmodifiableSet(entityStateListeners);
        this.statementListeners = Collections.unmodifiableSet(statementListeners);
        this.transactionIsolation = transactionIsolation;
        this.transactionListenerFactories = transactionListenerFactories;
        this.writeExecutor = writeExecutor;
    }

    @Override
    public int getBatchUpdateSize() {
        return this.batchUpdateSize;
    }

    @Override
    public EntityCache getCache() {
        return this.cache;
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Set<EntityStateListener> getEntityStateListeners() {
        return this.entityStateListeners;
    }

    @Override
    public Mapping getMapping() {
        return this.mapping;
    }

    @Override
    public EntityModel getModel() {
        return this.model;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public boolean getQuoteTableNames() {
        return this.quoteTableNames;
    }

    @Override
    public boolean getQuoteColumnNames() {
        return this.quoteColumnNames;
    }

    @Override
    public Function<String, String> getColumnTransformer() {
        return this.columnTransformer;
    }

    @Override
    public Function<String, String> getTableTransformer() {
        return this.tableTransformer;
    }

    @Override
    public int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    @Override
    public Set<StatementListener> getStatementListeners() {
        return this.statementListeners;
    }

    @Override
    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public Set<Supplier<TransactionListener>> getTransactionListenerFactories() {
        return this.transactionListenerFactories;
    }

    @Override
    public TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    @Override
    public boolean getUseDefaultLogging() {
        return this.useDefaultLogging;
    }

    @Override
    public Executor getWriteExecutor() {
        return this.writeExecutor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Configuration) {
            Configuration other = (Configuration)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.platform, this.connectionProvider, this.model, this.mapping, this.quoteColumnNames, this.quoteTableNames, this.transactionIsolation, this.transactionMode, this.statementCacheSize, this.transactionListenerFactories, this.useDefaultLogging});
    }

    public String toString() {
        return "platform: " + this.platform + "connectionProvider: " + this.connectionProvider + "model: " + this.model + "quoteColumnNames: " + this.quoteColumnNames + "quoteTableNames: " + this.quoteTableNames + "transactionMode" + (Object)((Object)this.transactionMode) + "transactionIsolation" + (Object)((Object)this.transactionIsolation) + "statementCacheSize: " + this.statementCacheSize + "useDefaultLogging: " + this.useDefaultLogging;
    }
}

