/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy.endpoints;

import eu.pretix.pretixscan.scanproxy.PretixScanConfig;
import eu.pretix.pretixscan.scanproxy.Server;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.NotFoundResponse;
import io.javalin.http.ServiceUnavailableResponse;
import io.javalin.http.UnauthorizedResponse;
import io.requery.query.Condition;
import io.requery.query.Result;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Leu/pretix/pretixscan/scanproxy/endpoints/DeviceAuth;", "Lio/javalin/http/Handler;", "()V", "handle", "", "ctx", "Lio/javalin/http/Context;", "server"})
public final class DeviceAuth
implements Handler {
    @NotNull
    public static final DeviceAuth INSTANCE = new DeviceAuth();

    private DeviceAuth() {
    }

    @Override
    public void handle(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String string = Server.INSTANCE.getDataDir();
        Intrinsics.checkNotNullExpressionValue(string, "Server.dataDir");
        PretixScanConfig configStore = new PretixScanConfig(string);
        if (!configStore.isConfigured()) {
            throw new ServiceUnavailableResponse("Not configured");
        }
        if (ctx.pathParamMap().containsKey("organizer") && !Intrinsics.areEqual(configStore.getOrganizerSlug(), ctx.pathParam("organizer"))) {
            throw new NotFoundResponse("Unknown organizer");
        }
        if (ctx.header("Authorization") == null) {
            throw new UnauthorizedResponse("Authorization required");
        }
        String string2 = ctx.header("Authorization");
        Intrinsics.checkNotNull(string2);
        String[] stringArray = new String[]{" "};
        List auth = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
        if (!Intrinsics.areEqual(auth.get(0), "Device")) {
            throw new UnauthorizedResponse("Device auth required");
        }
        Result result2 = (Result)Server.INSTANCE.getProxyData().select(Reflection.getOrCreateKotlinClass(DownstreamDeviceEntity.class)).where((Condition)DownstreamDeviceEntity.API_TOKEN.eq(auth.get(1))).get();
        DownstreamDeviceEntity downstreamDeviceEntity = (DownstreamDeviceEntity)result2.firstOrNull();
        if (downstreamDeviceEntity == null) {
            throw new UnauthorizedResponse("Unknown device token");
        }
        DownstreamDeviceEntity device = downstreamDeviceEntity;
        ctx.attribute("device", device);
    }
}

