/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.meta.Attribute;
import io.requery.meta.QueryExpression;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.util.LinkedHashSet;
import java.util.Set;

abstract class BaseType<T>
implements Type<T> {
    Class<T> type;
    Class<? super T> baseType;
    Type<?> superType;
    String name;
    boolean cacheable = true;
    boolean stateless;
    boolean readOnly;
    boolean immutable;
    boolean isView;
    Set<Attribute<T, ?>> attributes;
    Set<QueryExpression<?>> expressions;
    Supplier<T> factory;
    Function<T, EntityProxy<T>> proxyProvider;
    Set<Class<?>> referencedTypes = new LinkedHashSet();
    String[] tableCreateAttributes;
    String[] tableUniqueIndexes;
    Supplier<?> builderFactory;
    Function<?, T> buildFunction;
    Set<Attribute<T, ?>> keyAttributes;
    Attribute<T, ?> keyAttribute;

    BaseType() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getClassType() {
        return this.type;
    }

    @Override
    public Class<? super T> getBaseType() {
        return this.baseType;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.NAME;
    }

    @Override
    public Expression<T> getInnerExpression() {
        return null;
    }

    @Override
    public boolean isBuildable() {
        return this.builderFactory != null;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isStateless() {
        return this.stateless;
    }

    @Override
    public boolean isView() {
        return this.isView;
    }

    @Override
    public Set<Attribute<T, ?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<Attribute<T, ?>> getKeyAttributes() {
        return this.keyAttributes;
    }

    @Override
    public Attribute<T, ?> getSingleKeyAttribute() {
        return this.keyAttribute;
    }

    @Override
    public Set<QueryExpression<?>> getQueryExpressions() {
        return this.expressions;
    }

    @Override
    public <B> Supplier<B> getBuilderFactory() {
        Supplier<?> supplier = this.builderFactory;
        return supplier;
    }

    @Override
    public <B> Function<B, T> getBuildFunction() {
        Function<?, T> function2 = this.buildFunction;
        return function2;
    }

    @Override
    public Supplier<T> getFactory() {
        return this.factory;
    }

    @Override
    public Function<T, EntityProxy<T>> getProxyProvider() {
        return this.proxyProvider;
    }

    @Override
    public String[] getTableCreateAttributes() {
        return this.tableCreateAttributes;
    }

    @Override
    public String[] getTableUniqueIndexes() {
        return this.tableUniqueIndexes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Type) {
            Type other = (Type)obj;
            return Objects.equals(this.getClassType(), other.getClassType()) && Objects.equals(this.getName(), other.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "classType: " + this.type.toString() + " name: " + this.name + " readonly: " + this.readOnly + " immutable: " + this.immutable + " stateless: " + this.stateless + " cacheable: " + this.cacheable;
    }
}

