/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.pretix.libpretixsync.serialization.JSONArraySerializer;
import eu.pretix.libpretixsync.serialization.JSONObjectSerializer;
import eu.pretix.pretixscan.scanproxy.ProxyDependenciesKt;
import eu.pretix.pretixscan.scanproxy.ServerProxyDependencies;
import eu.pretix.pretixscan.scanproxy.SyncKt;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import eu.pretix.pretixscan.scanproxy.endpoints.AddEvent;
import eu.pretix.pretixscan.scanproxy.endpoints.AdminAuth;
import eu.pretix.pretixscan.scanproxy.endpoints.BadgeItemEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.BadgeLayoutEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckInListEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.ConfigState;
import eu.pretix.pretixscan.scanproxy.endpoints.DeviceAuth;
import eu.pretix.pretixscan.scanproxy.endpoints.DeviceInfo;
import eu.pretix.pretixscan.scanproxy.endpoints.DownloadEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EmptyResourceEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EventEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.EventRegister;
import eu.pretix.pretixscan.scanproxy.endpoints.EventSelection;
import eu.pretix.pretixscan.scanproxy.endpoints.EventsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.ItemEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.MultiCheckEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.MultiSearchEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.RemoveEvent;
import eu.pretix.pretixscan.scanproxy.endpoints.SearchEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SettingsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstream;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamInit;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamInitReady;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamRemove;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupUpstream;
import eu.pretix.pretixscan.scanproxy.endpoints.StatusEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SubEventEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SubEventsEndpoint;
import eu.pretix.pretixscan.scanproxy.endpoints.SyncEventList;
import eu.pretix.pretixscan.scanproxy.endpoints.SyncNow;
import eu.pretix.pretixscan.scanproxy.endpoints.UpstreamVersion;
import io.javalin.Javalin;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.config.JavalinConfig;
import io.javalin.http.Context;
import io.javalin.http.staticfiles.Location;
import io.javalin.json.JavalinJackson;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Leu/pretix/pretixscan/scanproxy/Server;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "VERSION", "", "getVERSION", "()Ljava/lang/String;", "VERSION_CODE", "", "getVERSION_CODE", "()I", "createApp", "Lio/javalin/Javalin;", "main", "", "args", "", "([Ljava/lang/String;)V", "server"})
public final class Server {
    @NotNull
    public static final Server INSTANCE = new Server();
    @NotNull
    private static final String VERSION = "2.5.0";
    private static final int VERSION_CODE = 14;
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);

    private Server() {
    }

    @NotNull
    public final String getVERSION() {
        return VERSION;
    }

    public final int getVERSION_CODE() {
        return VERSION_CODE;
    }

    @NotNull
    public final Javalin createApp() {
        Javalin app = Javalin.create(Server::createApp$lambda$2);
        app.routes(Server::createApp$lambda$13);
        Intrinsics.checkNotNullExpressionValue(app, "app");
        return app;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (!ProxyDependenciesKt.isProxyDepsInitialized()) {
            ProxyDependenciesKt.setProxyDeps(new ServerProxyDependencies());
        }
        Javalin app = INSTANCE.createApp();
        Thread webthread = new Thread(() -> Server.main$lambda$14(app));
        ScheduledExecutorService executor2 = Executors.newSingleThreadScheduledExecutor();
        Runnable periodicTask = Server::main$lambda$15;
        executor2.scheduleWithFixedDelay(periodicTask, 0L, 10L, TimeUnit.SECONDS);
        webthread.start();
    }

    private static final void createApp$lambda$2$lambda$0(Context ctx, Float f) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(f, "<anonymous parameter 1>");
        DownstreamDeviceEntity device = (DownstreamDeviceEntity)ctx.attribute("device");
        Object object = device;
        if (object == null || (object = ((DownstreamDeviceEntity)object).getName()) == null) {
            object = "";
        }
        Object device_name = object;
        LOG.info("[" + ctx.ip() + "] '" + (String)device_name + "' " + ctx.method() + " " + ctx.path() + " -> " + ctx.status());
    }

    private static final void createApp$lambda$2$lambda$1(SimpleModule $module, ObjectMapper mapper2) {
        Intrinsics.checkNotNullParameter($module, "$module");
        Intrinsics.checkNotNullParameter(mapper2, "mapper");
        mapper2.registerModule($module);
        mapper2.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static final void createApp$lambda$2(JavalinConfig config) {
        config.requestLogger.http(Server::createApp$lambda$2$lambda$0);
        config.staticFiles.add("/public", Location.CLASSPATH);
        SimpleModule module = new SimpleModule();
        module.addSerializer(JSONObject.class, new JSONObjectSerializer(null, 1, null));
        module.addSerializer(JSONArray.class, new JSONArraySerializer(null, 1, null));
        config.jsonMapper(new JavalinJackson(null, 1, null).updateMapper(arg_0 -> Server.createApp$lambda$2$lambda$1(module, arg_0)));
    }

    private static final void createApp$lambda$13$lambda$8$lambda$3() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get(DeviceInfo.INSTANCE);
    }

    private static final void createApp$lambda$13$lambda$8$lambda$4() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get(EventSelection.INSTANCE);
    }

    private static final void createApp$lambda$13$lambda$8$lambda$7$lambda$6$lambda$5() {
        ApiBuilder.before(EventRegister.INSTANCE);
        ApiBuilder.get(EventEndpoint.INSTANCE);
        ApiBuilder.get("categories/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("items/", ItemEndpoint.INSTANCE);
        ApiBuilder.get("questions/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("badgelayouts/", BadgeLayoutEndpoint.INSTANCE);
        ApiBuilder.get("checkinlists/", CheckInListEndpoint.INSTANCE);
        ApiBuilder.get("orders/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("badgeitems/", BadgeItemEndpoint.INSTANCE);
        ApiBuilder.get("settings/", SettingsEndpoint.INSTANCE);
        ApiBuilder.get("revokedsecrets/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("blockedsecrets/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.get("subevents/{id}/", SubEventEndpoint.INSTANCE);
    }

    private static final void createApp$lambda$13$lambda$8$lambda$7$lambda$6() {
        ApiBuilder.get(EventsEndpoint.INSTANCE);
        ApiBuilder.path("{event}", Server::createApp$lambda$13$lambda$8$lambda$7$lambda$6$lambda$5);
    }

    private static final void createApp$lambda$13$lambda$8$lambda$7() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get("subevents", SubEventsEndpoint.INSTANCE);
        ApiBuilder.get("reusablemedia/", EmptyResourceEndpoint.INSTANCE);
        ApiBuilder.path("events", Server::createApp$lambda$13$lambda$8$lambda$7$lambda$6);
    }

    private static final void createApp$lambda$13$lambda$8() {
        ApiBuilder.get("version", UpstreamVersion.INSTANCE);
        ApiBuilder.post("device/initialize", SetupDownstream.INSTANCE);
        ApiBuilder.path("device/info", Server::createApp$lambda$13$lambda$8$lambda$3);
        ApiBuilder.path("device/eventselection", Server::createApp$lambda$13$lambda$8$lambda$4);
        ApiBuilder.path("organizers/{organizer}", Server::createApp$lambda$13$lambda$8$lambda$7);
    }

    private static final void createApp$lambda$13$lambda$11$lambda$9() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get("status/", StatusEndpoint.INSTANCE);
        ApiBuilder.post("search/", SearchEndpoint.INSTANCE);
        ApiBuilder.post("check/", CheckEndpoint.INSTANCE);
    }

    private static final void createApp$lambda$13$lambda$11$lambda$10() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.post("search/", MultiSearchEndpoint.INSTANCE);
        ApiBuilder.post("check/", MultiCheckEndpoint.INSTANCE);
    }

    private static final void createApp$lambda$13$lambda$11() {
        ApiBuilder.before("configure", AdminAuth.INSTANCE);
        ApiBuilder.post("configure", SetupUpstream.INSTANCE);
        ApiBuilder.before("state", AdminAuth.INSTANCE);
        ApiBuilder.get("state", ConfigState.INSTANCE);
        ApiBuilder.before("removeevent", AdminAuth.INSTANCE);
        ApiBuilder.post("removeevent", RemoveEvent.INSTANCE);
        ApiBuilder.before("addevent", AdminAuth.INSTANCE);
        ApiBuilder.post("addevent", AddEvent.INSTANCE);
        ApiBuilder.before("init", AdminAuth.INSTANCE);
        ApiBuilder.post("init", SetupDownstreamInit.INSTANCE);
        ApiBuilder.before("initready", AdminAuth.INSTANCE);
        ApiBuilder.post("initready", SetupDownstreamInitReady.INSTANCE);
        ApiBuilder.before("remove", AdminAuth.INSTANCE);
        ApiBuilder.post("remove", SetupDownstreamRemove.INSTANCE);
        ApiBuilder.before("sync", AdminAuth.INSTANCE);
        ApiBuilder.post("sync", SyncNow.INSTANCE);
        ApiBuilder.before("synceventlist", AdminAuth.INSTANCE);
        ApiBuilder.post("synceventlist", SyncEventList.INSTANCE);
        ApiBuilder.path("rpc/{event}/{list}/", Server::createApp$lambda$13$lambda$11$lambda$9);
        ApiBuilder.path("rpc/", Server::createApp$lambda$13$lambda$11$lambda$10);
    }

    private static final void createApp$lambda$13$lambda$12() {
        ApiBuilder.before(DeviceAuth.INSTANCE);
        ApiBuilder.get("{filename}", DownloadEndpoint.INSTANCE);
    }

    private static final void createApp$lambda$13() {
        ApiBuilder.path("api/v1", Server::createApp$lambda$13$lambda$8);
        ApiBuilder.before("/", AdminAuth.INSTANCE);
        ApiBuilder.path("proxyapi/v1/", Server::createApp$lambda$13$lambda$11);
        ApiBuilder.path("download", Server::createApp$lambda$13$lambda$12);
    }

    private static final void main$lambda$14(Javalin $app) {
        Intrinsics.checkNotNullParameter($app, "$app");
        $app.start(7000);
    }

    private static final void main$lambda$15() {
        try {
            SyncKt.syncAllEvents$default(false, 1, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

