/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy.endpoints;

import eu.pretix.pretixscan.scanproxy.ProxyDependenciesKt;
import eu.pretix.pretixscan.scanproxy.ProxyScanConfig;
import eu.pretix.pretixscan.scanproxy.Server;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import eu.pretix.pretixscan.scanproxy.endpoints.SetupDownstreamKt;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Leu/pretix/pretixscan/scanproxy/endpoints/DeviceInfo;", "Lio/javalin/http/Handler;", "()V", "handle", "", "ctx", "Lio/javalin/http/Context;", "server"})
public final class DeviceInfo
implements Handler {
    @NotNull
    public static final DeviceInfo INSTANCE = new DeviceInfo();

    private DeviceInfo() {
    }

    @Override
    public void handle(@NotNull Context ctx) {
        Map map;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        ProxyScanConfig configStore2 = ProxyDependenciesKt.getProxyDeps().getConfigStore();
        Object t = ctx.attribute("device");
        Intrinsics.checkNotNull(t);
        DownstreamDeviceEntity device = (DownstreamDeviceEntity)t;
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[6];
        pairArray2[0] = TuplesKt.to("organizer", configStore2.getOrganizerSlug());
        pairArray2[1] = TuplesKt.to("device_id", 1);
        pairArray2[2] = TuplesKt.to("unique_serial", SetupDownstreamKt.uniqueSerial(device));
        pairArray2[3] = TuplesKt.to("api_token", device.getApi_token());
        pairArray2[4] = TuplesKt.to("name", device.getName());
        Long l = configStore2.getDeviceKnownGateID();
        Intrinsics.checkNotNullExpressionValue(l, "configStore.deviceKnownGateID");
        if (((Number)l).longValue() > 0L) {
            Pair[] pairArray3 = new Pair[]{TuplesKt.to("id", configStore2.getDeviceKnownGateID()), TuplesKt.to("name", configStore2.getDeviceKnownGateName())};
            map = MapsKt.mapOf(pairArray3);
        } else {
            map = null;
        }
        pairArray2[5] = TuplesKt.to("gate", map);
        pairArray[0] = TuplesKt.to("device", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("pretix", "?"), TuplesKt.to("pretix_numeric", configStore2.getKnownPretixVersion()), TuplesKt.to("pretixscan_proxy", Server.INSTANCE.getVERSION()), TuplesKt.to("pretixscan_proxy_numeric", Server.INSTANCE.getVERSION_CODE())};
        pairArray[1] = TuplesKt.to("server", MapsKt.mapOf(TuplesKt.to("version", MapsKt.mapOf(pairArray2))));
        pairArray[2] = TuplesKt.to("medium_key_sets", CollectionsKt.emptyList());
        ctx.json(MapsKt.mapOf(pairArray));
    }
}

