/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.check.QuestionType;
import eu.pretix.libpretixsync.db.QuestionOption;
import eu.pretix.libpretixsync.utils.EmailValidator;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class QuestionLike {
    public abstract QuestionType getType();

    public abstract String getQuestion();

    public abstract String getIdentifier();

    public abstract List<QuestionOption> getOptions();

    public abstract boolean requiresAnswer();

    public String getDefault() {
        return null;
    }

    public Long getValid_date_min() {
        return null;
    }

    public Long getValid_date_max() {
        return null;
    }

    public Long getValid_datetime_min() {
        return null;
    }

    public Long getValid_datetime_max() {
        return null;
    }

    public QuestionLike getDependency() {
        return null;
    }

    public List<String> getDependencyValues() {
        return new ArrayList<String>();
    }

    public void warn_answer(String answer, List<QuestionOption> opts, boolean allAnswersAreOptional) throws ValidationException {
    }

    public String clean_answer(String answer, List<QuestionOption> opts, boolean allAnswersAreOptional) throws ValidationException {
        QuestionType type2 = this.getType();
        if (!allAnswersAreOptional && this.requiresAnswer()) {
            if (type2 == QuestionType.B ? !answer.equals("True") && !answer.equals("true") : answer == null || answer.trim().equals("")) {
                throw new ValidationException("Question is required");
            }
        } else if ((answer == null || answer.trim().equals("")) && type2 != QuestionType.B) {
            return "";
        }
        if (answer.startsWith("file:///") && type2 != QuestionType.F) {
            throw new ValidationException("Question is not a file field");
        }
        if (type2 == QuestionType.N) {
            try {
                return new BigDecimal(answer).toPlainString();
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid number supplied");
            }
        }
        if (type2 == QuestionType.F) {
            if (!answer.startsWith("file:///") && !answer.startsWith("http")) {
                throw new ValidationException("Invalid file path supplied");
            }
        } else if (type2 == QuestionType.EMAIL) {
            if (!new EmailValidator().isValidEmail(answer)) {
                throw new ValidationException("Invalid email address supplied");
            }
        } else {
            if (type2 == QuestionType.B) {
                return answer.equals("True") || answer.equals("true") ? "True" : "False";
            }
            if (type2 == QuestionType.C) {
                for (QuestionOption o : opts) {
                    if (!o.getServer_id().toString().equals(answer)) continue;
                    return answer;
                }
                throw new ValidationException("Invalid choice supplied");
            }
            if (type2 == QuestionType.M) {
                HashSet<String> validChoices = new HashSet<String>();
                for (QuestionOption o : opts) {
                    validChoices.add(o.getServer_id().toString());
                }
                for (String a : answer.split(",")) {
                    if (validChoices.contains(a)) continue;
                    throw new ValidationException("Invalid choice supplied");
                }
            } else {
                if (type2 == QuestionType.D) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    dateFormat.setLenient(false);
                    try {
                        dateFormat.parse(answer);
                    }
                    catch (ParseException e) {
                        throw new ValidationException("Invalid date supplied");
                    }
                }
                if (type2 == QuestionType.H) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
                    dateFormat.setLenient(false);
                    try {
                        dateFormat.parse(answer);
                    }
                    catch (ParseException e) {
                        throw new ValidationException("Invalid time supplied");
                    }
                }
                if (type2 == QuestionType.W) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
                    dateFormat.setLenient(false);
                    try {
                        dateFormat.parse(answer);
                    }
                    catch (ParseException e) {
                        throw new ValidationException("Invalid datetime supplied");
                    }
                }
            }
        }
        return answer;
    }

    public static class ValidationException
    extends Exception {
        public ValidationException(String msg) {
            super(msg);
        }
    }
}

