/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.PGProperty;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PGPropertyPasswordParser;
import org.postgresql.util.PGPropertyServiceParser;
import org.postgresql.util.PGPropertyUtil;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.SharedTimer;
import org.postgresql.util.URLCoder;
import org.postgresql.util.internal.Nullness;

public class Driver
implements java.sql.Driver {
    private static @Nullable Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static final Logger LOGGER;
    private static final SharedTimer SHARED_TIMER;
    private @Nullable Properties defaultProperties;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl);
        ArrayList<URL> urls2 = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("org/postgresql/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls2.add(urlEnum.nextElement());
        }
        for (int i = urls2.size() - 1; i >= 0; --i) {
            URL url2 = (URL)urls2.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url2);
            InputStream is = url2.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public @Nullable Connection connect(String url2, @Nullable Properties info) throws SQLException {
        Properties defaults;
        if (url2 == null) {
            throw new SQLException("url is null");
        }
        if (!url2.startsWith("jdbc:postgresql:")) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url2, props)) == null) {
            throw new PSQLException(GT.tr("Unable to parse URL ", new Object[0]), PSQLState.UNEXPECTED_ERROR);
        }
        try {
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url2);
            long timeout2 = Driver.timeout(props);
            if (timeout2 <= 0L) {
                return Driver.makeConnection(url2, props);
            }
            ConnectThread ct = new ConnectThread(url2, props);
            Thread thread2 = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread2.setDaemon(true);
            thread2.start();
            return ct.getResult(timeout2);
        }
        catch (PSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private void setupLoggerFromProperties(Properties props) {
    }

    private static Connection makeConnection(String url2, Properties props) throws SQLException {
        return new PgConnection(Driver.hostSpecs(props), props, url2);
    }

    @Override
    public boolean acceptsURL(String url2) {
        return Driver.parseURL(url2, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url2, Properties info) {
        Properties copy2 = new Properties(info);
        Properties parse = Driver.parseURL(url2, copy2);
        if (parse != null) {
            copy2 = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy2);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver 42.3.8";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static @Nullable Properties parseURL(String url2, @Nullable Properties defaults) {
        String password;
        Properties result2;
        Properties priority1Url = new Properties();
        Properties priority3Service = new Properties();
        String urlServer = url2;
        String urlArgs = "";
        int qPos = url2.indexOf(63);
        if (qPos != -1) {
            urlServer = url2.substring(0, qPos);
            urlArgs = url2.substring(qPos + 1);
        }
        if (!urlServer.startsWith("jdbc:postgresql:")) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:postgresql:\" but was: {0}", url2);
            return null;
        }
        if ((urlServer = urlServer.substring("jdbc:postgresql:".length())).equals("//") || urlServer.equals("///")) {
            urlServer = "";
        } else if (urlServer.startsWith("//")) {
            long slashCount = (urlServer = urlServer.substring(2)).chars().filter(ch -> ch == 47).count();
            if (slashCount > 1L) {
                LOGGER.log(Level.WARNING, "JDBC URL contains too many / characters: {0}", url2);
                return null;
            }
            int slash = urlServer.indexOf(47);
            if (slash == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url2);
                return null;
            }
            if (!urlServer.endsWith("/")) {
                String value = Driver.urlDecode(urlServer.substring(slash + 1));
                if (value == null) {
                    return null;
                }
                PGProperty.PG_DBNAME.set(priority1Url, value);
            }
            urlServer = urlServer.substring(0, slash);
            String[] addresses = urlServer.split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    ports.append(portStr);
                    CharSequence hostStr = address.subSequence(0, portIdx);
                    if (hostStr.length() == 0) {
                        hosts.append(PGProperty.PG_HOST.getDefaultValue());
                    } else {
                        hosts.append(hostStr);
                    }
                } else {
                    ports.append(PGProperty.PG_PORT.getDefaultValue());
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            PGProperty.PG_HOST.set(priority1Url, hosts.toString());
            PGProperty.PG_PORT.set(priority1Url, ports.toString());
        } else {
            if (urlServer.startsWith("/")) {
                return null;
            }
            String value = Driver.urlDecode(urlServer);
            if (value == null) {
                return null;
            }
            priority1Url.setProperty(PGProperty.PG_DBNAME.getName(), value);
        }
        String[] args2 = urlArgs.split("&");
        String serviceName = null;
        for (String token : args2) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                priority1Url.setProperty(token, "");
                continue;
            }
            String pName = PGPropertyUtil.translatePGServiceToPGProperty(token.substring(0, pos));
            String pValue = Driver.urlDecode(token.substring(pos + 1));
            if (pValue == null) {
                return null;
            }
            if (PGProperty.SERVICE.getName().equals(pName)) {
                serviceName = pValue;
                continue;
            }
            priority1Url.setProperty(pName, pValue);
        }
        if (serviceName != null) {
            LOGGER.log(Level.FINE, "Processing option [?service={0}]", serviceName);
            result2 = PGPropertyServiceParser.getServiceProperties(serviceName);
            if (result2 == null) {
                LOGGER.log(Level.WARNING, "Definition of service [{0}] not found", serviceName);
                return null;
            }
            priority3Service.putAll((Map<?, ?>)result2);
        }
        result2 = new Properties();
        result2.putAll((Map<?, ?>)priority1Url);
        if (defaults != null) {
            defaults.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)result2::putIfAbsent));
        }
        priority3Service.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)result2::putIfAbsent));
        if (defaults != null) {
            defaults.stringPropertyNames().forEach(s2 -> result2.putIfAbsent(s2, Nullness.castNonNull(defaults.getProperty((String)s2))));
        }
        result2.putIfAbsent(PGProperty.PG_PORT.getName(), Nullness.castNonNull(PGProperty.PG_PORT.getDefaultValue()));
        result2.putIfAbsent(PGProperty.PG_HOST.getName(), Nullness.castNonNull(PGProperty.PG_HOST.getDefaultValue()));
        if (PGProperty.USER.get(result2) != null) {
            result2.putIfAbsent(PGProperty.PG_DBNAME.getName(), Nullness.castNonNull(PGProperty.USER.get(result2)));
        }
        if (!PGPropertyUtil.propertiesConsistencyCheck(result2)) {
            return null;
        }
        if (PGProperty.PASSWORD.get(result2) == null && (password = PGPropertyPasswordParser.getPassword(PGProperty.PG_HOST.get(result2), PGProperty.PG_PORT.get(result2), PGProperty.PG_DBNAME.get(result2), PGProperty.USER.get(result2))) != null && !password.isEmpty()) {
            PGProperty.PASSWORD.set(result2, password);
        }
        return result2;
    }

    private static @Nullable String urlDecode(String url2) {
        try {
            return URLCoder.decode(url2);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, "Url [{0}] parsing failed with error [{1}]", new Object[]{url2, e.getMessage()});
            return null;
        }
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(PGProperty.PG_HOST.get(props)).split(",");
        String[] ports = Nullness.castNonNull(PGProperty.PG_PORT.get(props)).split(",");
        String localSocketAddress = PGProperty.LOCAL_SOCKET_ADDRESS.get(props);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]), localSocketAddress);
        }
        return hostSpecs;
    }

    private static long timeout(Properties props) {
        String timeout2 = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout2 != null) {
            try {
                return (long)(Float.parseFloat(timeout2) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout2);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        PARENT_LOGGER = Logger.getLogger("org.postgresql");
        LOGGER = Logger.getLogger("org.postgresql.Driver");
        SHARED_TIMER = new SharedTimer();
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private @Nullable Connection result;
        private @Nullable Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url2, Properties props) {
            this.url = url2;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout2) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout2;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

