/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.TimeoutApiException;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.NonceGenerator;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.OrderSyncAdapter;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.Result;
import io.requery.query.WhereAndOr;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u00012BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001aH\u0016Jf\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010'\u001a\u00020\"H\u0016J2\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\rH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u001bH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Leu/pretix/libpretixsync/check/OnlineCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "fileStore", "Leu/pretix/libpretixsync/sync/FileStorage;", "fallback", "fallbackTimeout", "", "(Leu/pretix/libpretixsync/config/ConfigStore;Leu/pretix/libpretixsync/api/HttpClientFactory;Lio/requery/BlockingEntityStore;Leu/pretix/libpretixsync/sync/FileStorage;Leu/pretix/libpretixsync/check/TicketCheckProvider;I)V", "api", "Leu/pretix/libpretixsync/api/PretixApi;", "parser", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "eventsAndCheckinLists", "", "", "", "ticketid", "source_type", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "nonce", "allowQuestions", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "setSentry", "", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "eventSlug", "listId", "Companion", "libpretixsync"})
public final class OnlineCheckProvider
implements TicketCheckProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigStore config;
    @NotNull
    private final BlockingEntityStore<Persistable> dataStore;
    @NotNull
    private final FileStorage fileStore;
    @Nullable
    private final TicketCheckProvider fallback;
    private final int fallbackTimeout;
    @NotNull
    private SentryInterface sentry;
    @NotNull
    private final PretixApi api;
    private final DateTimeFormatter parser;

    public OnlineCheckProvider(@NotNull ConfigStore config, @Nullable HttpClientFactory httpClientFactory2, @NotNull BlockingEntityStore<Persistable> dataStore, @NotNull FileStorage fileStore, @Nullable TicketCheckProvider fallback, int fallbackTimeout) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        Intrinsics.checkNotNullParameter(fileStore, "fileStore");
        this.config = config;
        this.dataStore = dataStore;
        this.fileStore = fileStore;
        this.fallback = fallback;
        this.fallbackTimeout = fallbackTimeout;
        this.sentry = new DummySentryImplementation();
        this.api = PretixApi.Companion.fromConfig$default(PretixApi.Companion, this.config, httpClientFactory2, null, 4, null);
        this.parser = ISODateTimeFormat.dateTimeParser();
    }

    public /* synthetic */ OnlineCheckProvider(ConfigStore configStore2, HttpClientFactory httpClientFactory2, BlockingEntityStore blockingEntityStore, FileStorage fileStorage2, TicketCheckProvider ticketCheckProvider, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            ticketCheckProvider = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 30000;
        }
        this(configStore2, httpClientFactory2, blockingEntityStore, fileStorage2, ticketCheckProvider, n);
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
        this.api.setSentry(sentry);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid, @NotNull String source_type, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type2, @Nullable String nonce, boolean allowQuestions) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        Intrinsics.checkNotNullParameter(source_type, "source_type");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        CharSequence charSequence = ticketid;
        Object object = new Regex("[\\p{C}]");
        String string = "\ufffd";
        String ticketid_cleaned = ((Regex)object).replace(charSequence, string);
        String string2 = nonce;
        if (string2 == null) {
            string2 = NonceGenerator.nextNonce();
        }
        String nonce_cleaned = string2;
        this.sentry.addBreadcrumb("provider.check", "started");
        try {
            PretixApi.ApiResponse responseObj;
            PretixApi.ApiResponse apiResponse;
            Locale locale;
            String string3;
            TicketCheckProvider.CheckResult res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, false, 2, null);
            res.setScanType(type2);
            Long l = this.config.getKnownPretixVersion();
            Intrinsics.checkNotNullExpressionValue(l, "config.knownPretixVersion");
            if (((Number)l).longValue() >= 40120001001L) {
                List<Long> list = CollectionsKt.toList((Iterable)eventsAndCheckinLists.values());
                String string4 = null;
                string3 = type2.toString();
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale2, "getDefault()");
                locale = locale2;
                String string5 = string3;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).toLowerCase(locale)");
                apiResponse = this.api.redeem(list, ticketid_cleaned, string4, false, nonce_cleaned, answers, ignore_unpaid, with_badge_data, string6, this.fallback != null ? Long.valueOf(this.fallbackTimeout) : null, allowQuestions);
            } else {
                if (eventsAndCheckinLists.size() != 1) {
                    throw new CheckException("Multi-event scan not supported by server.", null, 2, null);
                }
                String string7 = (String)CollectionsKt.first((Iterable)eventsAndCheckinLists.keySet());
                String string8 = null;
                long l2 = ((Number)CollectionsKt.first((Iterable)eventsAndCheckinLists.values())).longValue();
                string3 = type2.toString();
                Locale locale3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale3, "getDefault()");
                locale = locale3;
                String string9 = string3;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.String).toLowerCase(locale)");
                apiResponse = responseObj = this.api.redeem(string7, ticketid_cleaned, string8, false, nonce_cleaned, answers, l2, ignore_unpaid, with_badge_data, string10, source_type, this.fallback != null ? Long.valueOf(this.fallbackTimeout) : null, allowQuestions);
            }
            if (responseObj.getResponse().code() == 404) {
                res.setType(TicketCheckProvider.CheckResult.Type.INVALID);
            } else {
                Object q;
                JSONObject jSONObject = responseObj.getData();
                Intrinsics.checkNotNull(jSONObject);
                JSONObject response = jSONObject;
                String status = response.getString("status");
                if (Intrinsics.areEqual("ok", status)) {
                    res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                } else if (Intrinsics.areEqual("incomplete", status)) {
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    List required_answers = new ArrayList();
                    int n = response.getJSONArray("questions").length();
                    for (int i = 0; i < n; ++i) {
                        q = response.getJSONArray("questions").getJSONObject(i);
                        Question question = new Question();
                        question.setServer_id(((JSONObject)q).getLong("id"));
                        question.setRequired(((JSONObject)q).getBoolean("required"));
                        question.setPosition(((JSONObject)q).getLong("position"));
                        question.setJson_data(((JSONObject)q).toString());
                        required_answers.add(new TicketCheckProvider.QuestionAnswer(question, ""));
                    }
                    res.setRequiredAnswers(required_answers);
                } else {
                    String reason = response.optString("reason");
                    if (Intrinsics.areEqual("already_redeemed", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.USED);
                    } else if (Intrinsics.areEqual("unknown_ticket", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.INVALID);
                    } else if (Intrinsics.areEqual("invalid_time", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                    } else if (Intrinsics.areEqual("blocked", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.BLOCKED);
                    } else if (Intrinsics.areEqual("canceled", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.CANCELED);
                    } else if (Intrinsics.areEqual("rules", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                    } else if (Intrinsics.areEqual("ambiguous", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.AMBIGUOUS);
                    } else if (Intrinsics.areEqual("revoked", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.REVOKED);
                    } else if (Intrinsics.areEqual("unapproved", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNAPPROVED);
                    } else if (Intrinsics.areEqual("unpaid", reason)) {
                        boolean bl;
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        if (response.has("list")) {
                            bl = response.getJSONObject("list").getBoolean("include_pending");
                        } else {
                            q = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq(CollectionsKt.first((Iterable)eventsAndCheckinLists.values()))).and((Condition)CheckInList.EVENT_SLUG.eq(CollectionsKt.first((Iterable)eventsAndCheckinLists.keySet())))).get()).firstOrNull();
                            if (q == null) {
                                throw new CheckException("Check-in list not found", null, 2, null);
                            }
                            Object list = q;
                            bl = ((CheckInList)list).isInclude_pending();
                        }
                        boolean includePending = bl;
                        res.setCheckinAllowed(includePending && response.has("position") && Intrinsics.areEqual(response.getJSONObject("position").optString("order__status", "n"), "n"));
                    } else if (Intrinsics.areEqual("product", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.PRODUCT);
                    } else {
                        res.setType(TicketCheckProvider.CheckResult.Type.ERROR);
                    }
                    if (response.has("reason_explanation") && !response.isNull("reason_explanation")) {
                        res.setReasonExplanation(response.getString("reason_explanation"));
                    }
                }
                if (response.has("list")) {
                    res.setEventSlug(response.getJSONObject("list").getString("event"));
                } else {
                    res.setEventSlug((String)CollectionsKt.first((Iterable)eventsAndCheckinLists.keySet()));
                }
                if (response.has("position")) {
                    JSONObject posjson = response.getJSONObject("position");
                    Item item = (Item)((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)posjson.getLong("item"))).get()).firstOrNull();
                    if (item != null) {
                        ItemVariation iv;
                        res.setTicket(item.getInternalName());
                        if (posjson.optLong("variation", 0L) > 0L && (iv = item.getVariation(posjson.getLong("variation"))) != null) {
                            res.setVariation(iv.getStringValue());
                        }
                    }
                    if (!posjson.isNull("attendee_name")) {
                        res.setAttendee_name(posjson.optString("attendee_name"));
                    }
                    if (!posjson.isNull("seat")) {
                        res.setSeat(posjson.getJSONObject("seat").getString("name"));
                    }
                    res.setOrderCode(posjson.optString("order"));
                    res.setPositionId(posjson.optLong("positionid"));
                    res.setPosition(posjson);
                    JSONArray checkins = posjson.getJSONArray("checkins");
                    int question = checkins.length();
                    for (int i = 0; i < question; ++i) {
                        JSONObject ci = checkins.getJSONObject(i);
                        if (!eventsAndCheckinLists.containsValue(ci.getLong("list"))) continue;
                        res.setFirstScanned(this.parser.parseDateTime(ci.getString("datetime")).toDate());
                    }
                    try {
                        JSONObject pdfdata;
                        if (posjson.has("pdf_data") && (pdfdata = posjson.getJSONObject("pdf_data")).has("images")) {
                            JSONObject images = pdfdata.getJSONObject("images");
                            OrderSyncAdapter.updatePdfImages(this.dataStore, this.fileStore, this.api, posjson.getLong("id"), images);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (posjson.has("answers") && posjson.getJSONArray("answers").length() > 0) {
                        List shownAnswers = new ArrayList();
                        int n = posjson.getJSONArray("answers").length();
                        for (int i = 0; i < n; ++i) {
                            JSONObject a = posjson.getJSONArray("answers").getJSONObject(i);
                            String value = a.getString("answer");
                            Object q2 = a.get("question");
                            if (!(q2 instanceof JSONObject)) continue;
                            Question question2 = new Question();
                            question2.setServer_id(((JSONObject)q2).getLong("id"));
                            question2.setRequired(((JSONObject)q2).getBoolean("required"));
                            question2.setPosition(((JSONObject)q2).getLong("position"));
                            question2.setJson_data(q2.toString());
                            if (!question2.isShowDuringCheckin()) continue;
                            shownAnswers.add(new TicketCheckProvider.QuestionAnswer(question2, value));
                        }
                        res.setShownAnswers(shownAnswers);
                    }
                }
                res.setRequireAttention(response.optBoolean("require_attention", false));
                if (response.has("checkin_texts")) {
                    JSONArray checkinTexts = response.getJSONArray("checkin_texts");
                    int n = checkinTexts.length();
                    TicketCheckProvider.CheckResult checkResult = res;
                    ArrayList<String> arrayList = new ArrayList<String>(n);
                    int n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        void it;
                        int n4;
                        int a = n4 = n2++;
                        ArrayList<String> arrayList2 = arrayList;
                        boolean bl = false;
                        arrayList2.add(checkinTexts.getString((int)it));
                    }
                    checkResult.setCheckinTexts((List<String>)arrayList);
                }
            }
            object = res;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            TicketCheckProvider.CheckResult cr = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Invalid server response", false, 4, null);
            if (e.getCause() != null) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull(throwable);
                cr.setTicket(throwable.getMessage());
            }
            object = cr;
        }
        catch (ApiException e) {
            TicketCheckProvider.CheckResult checkResult;
            if (e instanceof TimeoutApiException && this.fallback != null && nonce_cleaned != null) {
                checkResult = TicketCheckProvider.DefaultImpls.check$default(this.fallback, eventsAndCheckinLists, ticketid_cleaned, source_type, answers, ignore_unpaid, with_badge_data, type2, nonce_cleaned, false, 256, null);
            } else {
                this.sentry.addBreadcrumb("provider.check", "API Error: " + e.getMessage());
                TicketCheckProvider.CheckResult cr = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage(), false, 4, null);
                if (e.getCause() != null) {
                    Throwable throwable = e.getCause();
                    Intrinsics.checkNotNull(throwable);
                    cr.setTicket(throwable.getMessage());
                }
                checkResult = cr;
            }
            object = checkResult;
        }
        return object;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return TicketCheckProvider.DefaultImpls.check$default(this, eventsAndCheckinLists, ticketid, "barcode", new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY, null, false, 384, null);
    }

    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String query, int page) throws CheckException {
        List list;
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(query, "query");
        this.sentry.addBreadcrumb("provider.search", "started");
        try {
            PretixApi.ApiResponse apiResponse;
            Long l = this.config.getKnownPretixVersion();
            Intrinsics.checkNotNullExpressionValue(l, "config.knownPretixVersion");
            if (((Number)l).longValue() >= 40120001001L) {
                apiResponse = this.api.search(CollectionsKt.toList((Iterable)eventsAndCheckinLists.values()), query, page);
            } else {
                if (eventsAndCheckinLists.size() != 1) {
                    throw new CheckException("Multi-event scan not supported by server.", null, 2, null);
                }
                apiResponse = this.api.search((String)CollectionsKt.first((Iterable)eventsAndCheckinLists.keySet()), ((Number)CollectionsKt.first((Iterable)eventsAndCheckinLists.values())).longValue(), query, page);
            }
            PretixApi.ApiResponse response = apiResponse;
            JSONObject jSONObject = response.getData();
            Intrinsics.checkNotNull(jSONObject);
            JSONArray resdata = jSONObject.getJSONArray("results");
            List results = new ArrayList();
            int n = resdata.length();
            for (int i = 0; i < n; ++i) {
                JSONObject res = resdata.getJSONObject(i);
                TicketCheckProvider.SearchResult sr = new TicketCheckProvider.SearchResult();
                Item item = (Item)((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)res.getLong("item"))).get()).firstOrNull();
                if (item != null) {
                    ItemVariation iv;
                    sr.setTicket(item.getInternalName());
                    if (res.optLong("variation", 0L) > 0L && (iv = item.getVariation(res.getLong("variation"))) != null) {
                        sr.setVariation(iv.getStringValue());
                    }
                }
                if (!res.isNull("attendee_name")) {
                    sr.setAttendee_name(res.optString("attendee_name"));
                }
                if (!res.isNull("seat")) {
                    sr.setSeat(res.getJSONObject("seat").getString("name"));
                }
                sr.setOrderCode(res.optString("order"));
                sr.setPositionId(res.optLong("positionid"));
                sr.setSecret(res.optString("secret"));
                sr.setRedeemed(res.getJSONArray("checkins").length() > 0);
                String status = res.optString("order__status", "p");
                if (Intrinsics.areEqual(status, "p")) {
                    sr.setStatus(TicketCheckProvider.SearchResult.Status.PAID);
                } else if (Intrinsics.areEqual(status, "n")) {
                    sr.setStatus(TicketCheckProvider.SearchResult.Status.PENDING);
                } else {
                    sr.setStatus(TicketCheckProvider.SearchResult.Status.CANCELED);
                }
                sr.setRequireAttention(res.optBoolean("require_attention", false));
                sr.setPosition(res);
                results.add(sr);
            }
            list = results;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new CheckException("Unknown server response", e);
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", "API Error: " + e.getMessage());
            throw new CheckException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    @Nullable
    public TicketCheckProvider.StatusResult status(@NotNull String eventSlug, long listId) throws CheckException {
        TicketCheckProvider.StatusResult statusResult;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        this.sentry.addBreadcrumb("provider.status", "started");
        try {
            PretixApi.ApiResponse response = this.api.status(eventSlug, listId);
            JSONObject jSONObject = response.getData();
            Intrinsics.checkNotNull(jSONObject);
            TicketCheckProvider.StatusResult r = Companion.parseStatusResponse(jSONObject);
            CheckInList list = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
            if (list != null) {
                r.setEventName(r.getEventName() + " \u2013 " + list.name);
            }
            statusResult = r;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new CheckException("Unknown server response", e);
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", "API Error: " + e.getMessage());
            throw new CheckException(e.getMessage(), e);
        }
        return statusResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Leu/pretix/libpretixsync/check/OnlineCheckProvider$Companion;", "", "()V", "parseStatusResponse", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "response", "Lorg/json/JSONObject;", "libpretixsync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TicketCheckProvider.StatusResult parseStatusResponse(@NotNull JSONObject response) throws JSONException {
            Intrinsics.checkNotNullParameter(response, "response");
            List items = new ArrayList();
            int itemcount = response.getJSONArray("items").length();
            for (int i = 0; i < itemcount; ++i) {
                JSONObject item = response.getJSONArray("items").getJSONObject(i);
                List variations = new ArrayList();
                int varcount = item.getJSONArray("variations").length();
                for (int j = 0; j < varcount; ++j) {
                    JSONObject var = item.getJSONArray("variations").getJSONObject(j);
                    variations.add(new TicketCheckProvider.StatusResultItemVariation(var.getLong("id"), var.getString("value"), var.getInt("position_count"), var.getInt("checkin_count")));
                }
                items.add(new TicketCheckProvider.StatusResultItem(item.getLong("id"), item.getString("name"), item.getInt("position_count"), item.getInt("checkin_count"), variations, item.getBoolean("admission")));
            }
            return new TicketCheckProvider.StatusResult(response.getJSONObject("event").getString("name"), response.getInt("position_count"), response.getInt("checkin_count"), response.has("inside_count") ? Integer.valueOf(response.optInt("inside_count")) : null, items);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

