/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.db.ReusableMedium;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReusableMediaSyncAdapter
extends BaseDownloadSyncAdapter<ReusableMedium, Long> {
    private String firstResponseTimestamp;
    private String lastMediumTimestamp;
    private ResourceSyncStatus rlm;

    public ReusableMediaSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCylceId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, "__all__", api, syncCylceId, feedback);
    }

    private String rlmName() {
        return "reusablemedia";
    }

    @Override
    protected String getUrl() {
        return this.api.organizerResourceUrl(this.getResourceName());
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        boolean completed = false;
        try {
            super.download();
            completed = true;
        }
        finally {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.rlmName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)"__all__"))).limit(1).get()).firstOrNull();
            if (this.firstResponseTimestamp != null) {
                if (resourceSyncStatus == null) {
                    resourceSyncStatus = new ResourceSyncStatus();
                    resourceSyncStatus.setResource(this.rlmName());
                    resourceSyncStatus.setEvent_slug("__all__");
                    if (completed) {
                        resourceSyncStatus.setStatus("complete");
                    } else {
                        resourceSyncStatus.setStatus("incomplete:" + this.lastMediumTimestamp);
                    }
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                } else if (completed) {
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                }
            } else if (completed && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("complete");
                this.store.update(resourceSyncStatus);
            } else if (!completed && this.lastMediumTimestamp != null && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("incomplete:" + this.lastMediumTimestamp);
                this.store.update(resourceSyncStatus);
            }
            this.lastMediumTimestamp = null;
            this.firstResponseTimestamp = null;
        }
    }

    @Override
    public void updateObject(ReusableMedium obj, JSONObject jsonobj) throws JSONException {
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setType(jsonobj.getString("type"));
        obj.setIdentifier(jsonobj.getString("identifier"));
        obj.setActive(jsonobj.getBoolean("active"));
        obj.setExpires(jsonobj.optString("expires"));
        obj.setCustomer_id(jsonobj.optLong("customer"));
        obj.setLinked_giftcard_id(jsonobj.optLong("linked_giftcard"));
        obj.setLinked_orderposition_id(jsonobj.optLong("linked_orderposition"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    protected boolean deleteUnseen() {
        return false;
    }

    @Override
    protected JSONObject downloadPage(String url2, boolean isFirstPage) throws ApiException, ResourceNotModified {
        if (isFirstPage) {
            this.rlm = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.rlmName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)"__all__"))).limit(1).get()).firstOrNull();
        }
        boolean is_continued_fetch = false;
        if (this.rlm != null) {
            if (this.rlm.getStatus() != null && this.rlm.getStatus().startsWith("incomplete:")) {
                is_continued_fetch = true;
                try {
                    if (!url2.contains("created_since")) {
                        url2 = url2 + "?ordering=datetime&created_since=" + URLEncoder.encode(this.rlm.getStatus().substring(11), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (!url2.contains("updated_since")) {
                        url2 = url2 + "?ordering=-updated&updated_since=" + URLEncoder.encode(this.rlm.getLast_modified(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url2);
        if (isFirstPage && !is_continued_fetch) {
            this.firstResponseTimestamp = apiResponse.getResponse().header("X-Page-Generated");
        }
        JSONObject d = apiResponse.getData();
        if (apiResponse.getResponse().code() == 200) {
            try {
                JSONArray res = d.getJSONArray("results");
                if (res.length() > 0) {
                    this.lastMediumTimestamp = res.getJSONObject(res.length() - 1).getString("created");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return d;
    }

    @Override
    public CloseableIterator<ReusableMedium> runBatch(List<Long> ids) {
        return ((Result)this.store.select(ReusableMedium.class, new QueryAttribute[0]).where(ReusableMedium.SERVER_ID.in(ids)).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(ReusableMedium.SERVER_ID).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "reusablemedia";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(ReusableMedium obj) {
        return obj.getServer_id();
    }

    @Override
    ReusableMedium newEmptyObject() {
        return new ReusableMedium();
    }
}

