/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.query.Expression;
import io.requery.query.NamedExpression;
import io.requery.util.Objects;
import java.util.ArrayList;

public class BoundParameters {
    private final ArrayList<Expression<?>> expressions = new ArrayList();
    private final ArrayList<Object> values = new ArrayList();

    public BoundParameters() {
    }

    public BoundParameters(Object ... parameters2) {
        this();
        int index = 0;
        for (Object parameter : parameters2) {
            Class type2 = parameter == null ? Object.class : parameter.getClass();
            NamedExpression<Object> expression = NamedExpression.of(String.valueOf(index++), type2);
            this.add(expression, parameter);
        }
    }

    public <V> void add(Expression<V> expression, V value) {
        this.expressions.add(expression);
        this.values.add(value);
    }

    Expression<?> expressionAt(int index) {
        return this.expressions.get(index);
    }

    Object valueAt(int index) {
        return this.values.get(index);
    }

    public int count() {
        return this.expressions.size();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public void addAll(BoundParameters parameters2) {
        this.expressions.addAll(parameters2.expressions);
        this.values.addAll(parameters2.values);
    }

    public void clear() {
        this.expressions.clear();
        this.values.clear();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoundParameters) {
            BoundParameters parameters2 = (BoundParameters)obj;
            return Objects.equals(this.values, parameters2.values);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.values.size(); ++i) {
            Object value = this.valueAt(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(value));
        }
        sb.append("]");
        return sb.toString();
    }
}

