/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.BlockingEntityStore;
import io.requery.EntityCache;
import io.requery.PersistenceException;
import io.requery.ReadOnlyException;
import io.requery.RollbackException;
import io.requery.Transaction;
import io.requery.TransactionException;
import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.cache.EmptyEntityCache;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.QueryAttribute;
import io.requery.meta.Type;
import io.requery.proxy.CompositeKey;
import io.requery.proxy.EntityProxy;
import io.requery.query.Condition;
import io.requery.query.Deletion;
import io.requery.query.Expression;
import io.requery.query.InsertInto;
import io.requery.query.Insertion;
import io.requery.query.Result;
import io.requery.query.Scalar;
import io.requery.query.Selection;
import io.requery.query.Tuple;
import io.requery.query.Update;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryType;
import io.requery.query.function.Count;
import io.requery.sql.Attributes;
import io.requery.sql.CompositeEntityListener;
import io.requery.sql.CompositeStatementListener;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.EntityContext;
import io.requery.sql.EntityReader;
import io.requery.sql.EntityStateListener;
import io.requery.sql.EntityTransaction;
import io.requery.sql.EntityWriter;
import io.requery.sql.GeneratedKeys;
import io.requery.sql.GenericMapping;
import io.requery.sql.InsertReturningOperation;
import io.requery.sql.LoggingListener;
import io.requery.sql.Mapping;
import io.requery.sql.MissingKeyException;
import io.requery.sql.Platform;
import io.requery.sql.PreparedStatementCache;
import io.requery.sql.QueryBuilder;
import io.requery.sql.RawEntityQuery;
import io.requery.sql.RawTupleQuery;
import io.requery.sql.ResultReader;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.SelectCountOperation;
import io.requery.sql.SelectOperation;
import io.requery.sql.StatementCachingConnection;
import io.requery.sql.StatementListener;
import io.requery.sql.TransactionMode;
import io.requery.sql.TransactionProvider;
import io.requery.sql.TransactionScope;
import io.requery.sql.TupleResultReader;
import io.requery.sql.UpdateOperation;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.StatementGenerator;
import io.requery.sql.platform.PlatformDelegate;
import io.requery.util.ClassMap;
import io.requery.util.Objects;
import io.requery.util.function.Supplier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;

@ParametersAreNonnullByDefault
public class EntityDataStore<T>
implements BlockingEntityStore<T> {
    private final EntityModel entityModel;
    private final EntityCache entityCache;
    private final ConnectionProvider connectionProvider;
    private final ClassMap<EntityReader<?, ?>> readers;
    private final ClassMap<EntityWriter<?, ?>> writers;
    private final CompositeEntityListener<T> stateListeners;
    private final CompositeStatementListener statementListeners;
    private final UpdateOperation updateOperation;
    private final SelectCountOperation countOperation;
    private final TransactionProvider transactionProvider;
    private final Configuration configuration;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final DataContext context;
    private final Mapping mapping;
    private TransactionMode transactionMode;
    private PreparedStatementCache statementCache;
    private QueryBuilder.Options queryOptions;
    private Platform platform;
    private Generator<QueryElement<?>> statementGenerator;
    private boolean metadataChecked;
    private boolean supportsBatchUpdates;

    public EntityDataStore(DataSource dataSource, EntityModel model) {
        this(dataSource, model, null);
    }

    public EntityDataStore(DataSource dataSource, EntityModel model, @Nullable Mapping mapping) {
        this(new ConfigurationBuilder(dataSource, model).setMapping(mapping).build());
    }

    public EntityDataStore(Configuration configuration) {
        this.readers = new ClassMap();
        this.writers = new ClassMap();
        this.entityModel = Objects.requireNotNull(configuration.getModel());
        this.connectionProvider = Objects.requireNotNull(configuration.getConnectionProvider());
        this.mapping = configuration.getMapping() == null ? new GenericMapping() : configuration.getMapping();
        this.platform = configuration.getPlatform();
        this.transactionMode = configuration.getTransactionMode();
        this.configuration = configuration;
        this.statementListeners = new CompositeStatementListener(configuration.getStatementListeners());
        this.stateListeners = new CompositeEntityListener();
        this.entityCache = configuration.getCache() == null ? new EmptyEntityCache() : configuration.getCache();
        int statementCacheSize = configuration.getStatementCacheSize();
        if (statementCacheSize > 0) {
            this.statementCache = new PreparedStatementCache(statementCacheSize);
        }
        if (this.platform != null) {
            this.platform.addMappings(this.mapping);
        }
        this.context = new DataContext();
        this.transactionProvider = new TransactionProvider(this.context);
        this.updateOperation = new UpdateOperation(this.context);
        this.countOperation = new SelectCountOperation(this.context);
        LinkedHashSet<EntityStateListener> entityListeners = new LinkedHashSet<EntityStateListener>();
        if (configuration.getUseDefaultLogging()) {
            LoggingListener logListener = new LoggingListener();
            entityListeners.add(logListener);
            this.statementListeners.add(logListener);
        }
        if (!configuration.getEntityStateListeners().isEmpty()) {
            for (EntityStateListener entityStateListener : configuration.getEntityStateListeners()) {
                entityListeners.add(entityStateListener);
            }
        }
        if (!entityListeners.isEmpty()) {
            this.stateListeners.enableStateListeners(true);
            for (EntityStateListener<Object> entityStateListener : entityListeners) {
                this.stateListeners.addPostLoadListener(entityStateListener);
                this.stateListeners.addPostInsertListener(entityStateListener);
                this.stateListeners.addPostDeleteListener(entityStateListener);
                this.stateListeners.addPostUpdateListener(entityStateListener);
                this.stateListeners.addPreInsertListener(entityStateListener);
                this.stateListeners.addPreDeleteListener(entityStateListener);
                this.stateListeners.addPreUpdateListener(entityStateListener);
            }
        }
    }

    @Override
    public <E extends T> E insert(E entity) {
        this.insert(entity, null);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, E extends T> K insert(E entity, @Nullable Class<K> keyClass) {
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            EntityProxy<E> proxy = this.context.proxyOf(entity, true);
            Object object = proxy.syncObject();
            synchronized (object) {
                block20: {
                    EntityWriter writer = this.context.write(proxy.type().getClassType());
                    GeneratedKeys<E> key = null;
                    if (keyClass != null) {
                        key = new GeneratedKeys<E>(proxy.type().isImmutable() ? null : proxy);
                    }
                    writer.insert(entity, proxy, key);
                    transaction.commit();
                    if (key == null || key.size() <= 0) break block20;
                    K k = keyClass.cast(key.get(0));
                    return k;
                }
            }
        }
        return null;
    }

    @Override
    public <E extends T> Iterable<E> insert(Iterable<E> entities) {
        this.insert((Iterable)entities, (Class)null);
        return entities;
    }

    @Override
    public <K, E extends T> Iterable<K> insert(Iterable<E> entities, @Nullable Class<K> keyClass) {
        Iterator<E> iterator2 = entities.iterator();
        if (iterator2.hasNext()) {
            try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
                GeneratedKeys<E> result2;
                E entity = iterator2.next();
                EntityProxy<E> proxy = this.context.proxyOf(entity, true);
                EntityWriter writer = this.context.write(proxy.type().getClassType());
                GeneratedKeys<E> keys2 = writer.batchInsert(entities, keyClass != null);
                transaction.commit();
                GeneratedKeys<E> generatedKeys = result2 = keys2;
                return generatedKeys;
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E update(E entity) {
        Throwable throwable = null;
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            EntityProxy<E> proxy = this.context.proxyOf(entity, true);
            Object object = proxy.syncObject();
            synchronized (object) {
                E e;
                try {
                    this.context.write(proxy.type().getClassType()).update(entity, proxy);
                    transaction.commit();
                    e = entity;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                return e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E update(E entity, Attribute<?, ?> ... attributes) {
        Throwable throwable = null;
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            EntityProxy<E> proxy = this.context.proxyOf(entity, true);
            Object object = proxy.syncObject();
            synchronized (object) {
                E e;
                try {
                    this.context.write(proxy.type().getClassType()).update(entity, proxy, attributes);
                    transaction.commit();
                    e = entity;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                return e;
            }
        }
    }

    @Override
    public <E extends T> Iterable<E> update(Iterable<E> entities) {
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            for (E entity : entities) {
                this.update(entity);
            }
            transaction.commit();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E upsert(E entity) {
        Throwable throwable = null;
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            EntityProxy<E> proxy = this.context.proxyOf(entity, true);
            Object object = proxy.syncObject();
            synchronized (object) {
                E e;
                try {
                    EntityWriter writer = this.context.write(proxy.type().getClassType());
                    writer.upsert(entity, proxy);
                    transaction.commit();
                    e = entity;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                return e;
            }
        }
    }

    @Override
    public <E extends T> Iterable<E> upsert(Iterable<E> entities) {
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            for (E entity : entities) {
                this.upsert(entity);
            }
            transaction.commit();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E refresh(E entity) {
        EntityProxy<E> proxy = this.context.proxyOf(entity, false);
        Object object = proxy.syncObject();
        synchronized (object) {
            return this.context.read(proxy.type().getClassType()).refresh(entity, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E refresh(E entity, Attribute<?, ?> ... attributes) {
        EntityProxy<E> proxy = this.context.proxyOf(entity, false);
        Object object = proxy.syncObject();
        synchronized (object) {
            return this.context.read(proxy.type().getClassType()).refresh(entity, proxy, attributes);
        }
    }

    @Override
    public <E extends T> Iterable<E> refresh(Iterable<E> entities, Attribute<?, ?> ... attributes) {
        Iterator<E> iterator2 = entities.iterator();
        if (iterator2.hasNext()) {
            E entity = iterator2.next();
            EntityProxy<E> proxy = this.context.proxyOf(entity, false);
            EntityReader reader = this.context.read(proxy.type().getClassType());
            return reader.batchRefresh(entities, attributes);
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> E refreshAll(E entity) {
        EntityProxy<E> proxy = this.context.proxyOf(entity, false);
        Object object = proxy.syncObject();
        synchronized (object) {
            return this.context.read(proxy.type().getClassType()).refreshAll(entity, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends T> Void delete(E entity) {
        try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
            EntityProxy<E> proxy = this.context.proxyOf(entity, true);
            Object object = proxy.syncObject();
            synchronized (object) {
                this.context.write(proxy.type().getClassType()).delete(entity, proxy);
                transaction.commit();
            }
        }
        return null;
    }

    @Override
    public <E extends T> Void delete(Iterable<E> entities) {
        Iterator<E> iterator2;
        if (entities instanceof Result) {
            Result result2 = (Result)entities;
            entities = result2.toList();
        }
        if ((iterator2 = entities.iterator()).hasNext()) {
            try (TransactionScope transaction = new TransactionScope(this.transactionProvider);){
                E entity = iterator2.next();
                EntityProxy<E> proxy = this.context.proxyOf(entity, true);
                EntityWriter writer = this.context.write(proxy.type().getClassType());
                writer.delete(entities);
                transaction.commit();
            }
        }
        return null;
    }

    @Override
    public <E extends T, K> E findByKey(Class<E> type2, K key) {
        E entity;
        Type<E> entityType = this.entityModel.typeOf(type2);
        if (entityType.isCacheable() && this.entityCache != null && (entity = this.entityCache.get(type2, key)) != null) {
            return entity;
        }
        Set<Attribute<E, ?>> keys2 = entityType.getKeyAttributes();
        if (keys2.isEmpty()) {
            throw new MissingKeyException();
        }
        Selection<Result<E>> selection = this.select(type2, new QueryAttribute[0]);
        if (keys2.size() == 1) {
            QueryAttribute attribute = Attributes.query(keys2.iterator().next());
            selection.where((Condition)attribute.equal(key));
        } else if (key instanceof CompositeKey) {
            CompositeKey compositeKey = (CompositeKey)key;
            for (Attribute<E, ?> attribute : keys2) {
                QueryAttribute keyAttribute = Attributes.query(attribute);
                Object value = compositeKey.get(keyAttribute);
                selection.where((Condition)keyAttribute.equal(value));
            }
        } else {
            throw new IllegalArgumentException("CompositeKey required");
        }
        return ((Result)selection.get()).firstOrNull();
    }

    @Override
    public Transaction transaction() {
        this.checkClosed();
        return this.transactionProvider.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.entityCache.clear();
            if (this.statementCache != null) {
                this.statementCache.close();
            }
        }
    }

    @Override
    public Selection<? extends Result<Tuple>> select(Expression<?> ... expressions) {
        TupleResultReader reader = new TupleResultReader(this.context);
        SelectOperation<Tuple> select = new SelectOperation<Tuple>(this.context, reader);
        return new QueryElement<Tuple>(QueryType.SELECT, this.entityModel, select).select((Expression[])expressions);
    }

    @Override
    public Selection<? extends Result<Tuple>> select(Set<? extends Expression<?>> expressions) {
        TupleResultReader reader = new TupleResultReader(this.context);
        SelectOperation<Tuple> select = new SelectOperation<Tuple>(this.context, reader);
        return new QueryElement<Tuple>(QueryType.SELECT, this.entityModel, select).select(expressions);
    }

    @Override
    public Update<? extends Scalar<Integer>> update() {
        this.checkClosed();
        return new QueryElement<Scalar<Integer>>(QueryType.UPDATE, this.entityModel, this.updateOperation);
    }

    @Override
    public Deletion<? extends Scalar<Integer>> delete() {
        this.checkClosed();
        return new QueryElement<Scalar<Integer>>(QueryType.DELETE, this.entityModel, this.updateOperation);
    }

    @Override
    public <E extends T> Selection<? extends Result<E>> select(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        ResultReader<E> resultReader;
        Set<Expression<?>> selection;
        this.checkClosed();
        EntityReader reader = this.context.read(type2);
        if (attributes.length == 0) {
            selection = reader.defaultSelection();
            resultReader = reader.newResultReader(reader.defaultSelectionAttributes());
        } else {
            selection = new LinkedHashSet(Arrays.asList(attributes));
            resultReader = reader.newResultReader(attributes);
        }
        SelectOperation<E> select = new SelectOperation<E>(this.context, resultReader);
        QueryElement<E> query = new QueryElement<E>(QueryType.SELECT, this.entityModel, select);
        return ((QueryElement)query.select((Set)selection)).from(new Class[]{type2});
    }

    @Override
    public <E extends T> Selection<? extends Result<E>> select(Class<E> type2, Set<? extends QueryAttribute<E, ?>> attributes) {
        QueryAttribute[] array = attributes.toArray(new QueryAttribute[attributes.size()]);
        return this.select(type2, array);
    }

    @Override
    public <E extends T> Insertion<? extends Result<Tuple>> insert(Class<E> type2) {
        this.checkClosed();
        Set<Expression<?>> generated = this.generatedExpressions(type2);
        InsertReturningOperation operation = new InsertReturningOperation((RuntimeConfiguration)this.context, generated);
        return new QueryElement<Result<Tuple>>(QueryType.INSERT, this.entityModel, operation).from(new Class[]{type2});
    }

    @Override
    public <E extends T> InsertInto<? extends Result<Tuple>> insert(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        this.checkClosed();
        Set<Expression<?>> generated = this.generatedExpressions(type2);
        InsertReturningOperation operation = new InsertReturningOperation((RuntimeConfiguration)this.context, generated);
        return new QueryElement<Result<Tuple>>(QueryType.INSERT, this.entityModel, operation).insertColumns(attributes);
    }

    Set<Expression<?>> generatedExpressions(Class<? extends T> type2) {
        Type<T> entityType = this.context.getModel().typeOf(type2);
        LinkedHashSet keySelection = new LinkedHashSet();
        for (Attribute<T, ?> attribute : entityType.getKeyAttributes()) {
            if (!attribute.isGenerated()) continue;
            keySelection.add((Expression)((Object)attribute));
        }
        return keySelection;
    }

    @Override
    public <E extends T> Update<? extends Scalar<Integer>> update(Class<E> type2) {
        this.checkClosed();
        return new QueryElement<Scalar<Integer>>(QueryType.UPDATE, this.entityModel, this.updateOperation).from(new Class[]{type2});
    }

    @Override
    public <E extends T> Deletion<? extends Scalar<Integer>> delete(Class<E> type2) {
        this.checkClosed();
        return new QueryElement<Scalar<Integer>>(QueryType.DELETE, this.entityModel, this.updateOperation).from(new Class[]{type2});
    }

    @Override
    public <E extends T> Selection<? extends Scalar<Integer>> count(Class<E> type2) {
        this.checkClosed();
        Objects.requireNotNull(type2);
        return ((QueryElement)new QueryElement<Scalar<Integer>>(QueryType.SELECT, this.entityModel, this.countOperation).select(new Expression[]{Count.count(type2)})).from(new Class[]{type2});
    }

    @Override
    public Selection<? extends Scalar<Integer>> count(QueryAttribute<?, ?> ... attributes) {
        this.checkClosed();
        return new QueryElement<Scalar<Integer>>(QueryType.SELECT, this.entityModel, this.countOperation).select(new Expression[]{Count.count(attributes)});
    }

    @Override
    public Result<Tuple> raw(String query, Object ... parameters2) {
        this.checkClosed();
        return new RawTupleQuery(this.context, query, parameters2).get();
    }

    @Override
    public <E extends T> Result<E> raw(Class<E> type2, String query, Object ... parameters2) {
        this.checkClosed();
        return new RawEntityQuery(this.context, type2, query, parameters2).get();
    }

    @Override
    public <V> V runInTransaction(Callable<V> callable, @Nullable TransactionIsolation isolation) {
        Objects.requireNotNull(callable);
        this.checkClosed();
        Throwable throwable = null;
        try (EntityTransaction transaction = this.transactionProvider.get();){
            V v;
            if (transaction == null) {
                throw new TransactionException("no transaction");
            }
            try {
                transaction.begin(isolation);
                V result2 = callable.call();
                transaction.commit();
                v = result2;
            }
            catch (Exception e) {
                try {
                    transaction.rollback();
                    throw new RollbackException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            return v;
        }
    }

    @Override
    public <V> V runInTransaction(Callable<V> callable) {
        return this.runInTransaction(callable, null);
    }

    @Override
    public BlockingEntityStore<T> toBlocking() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionMetadata() {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            if (!this.metadataChecked) {
                try (Connection connection = this.context.getConnection();){
                    DatabaseMetaData metadata2 = connection.getMetaData();
                    if (!metadata2.supportsTransactions()) {
                        this.transactionMode = TransactionMode.NONE;
                    }
                    this.supportsBatchUpdates = metadata2.supportsBatchUpdates();
                    String quoteIdentifier = metadata2.getIdentifierQuoteString();
                    this.queryOptions = new QueryBuilder.Options(quoteIdentifier, true, this.configuration.getTableTransformer(), this.configuration.getColumnTransformer(), this.configuration.getQuoteTableNames(), this.configuration.getQuoteColumnNames());
                    this.metadataChecked = true;
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
    }

    protected void checkClosed() {
        if (this.closed.get()) {
            throw new PersistenceException("closed");
        }
    }

    protected EntityContext<T> context() {
        return this.context;
    }

    protected class DataContext
    implements EntityContext<T>,
    ConnectionProvider {
        protected DataContext() {
        }

        @Override
        public <E> EntityProxy<E> proxyOf(E entity, boolean forUpdate) {
            EntityTransaction transaction;
            EntityDataStore.this.checkClosed();
            Type<?> type2 = EntityDataStore.this.entityModel.typeOf(entity.getClass());
            EntityProxy<?> proxy = type2.getProxyProvider().apply(entity);
            if (forUpdate && type2.isReadOnly()) {
                throw new ReadOnlyException();
            }
            if (forUpdate && (transaction = EntityDataStore.this.transactionProvider.get()) != null && transaction.active()) {
                transaction.addToTransaction(proxy);
            }
            return proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = null;
            EntityTransaction transaction = EntityDataStore.this.transactionProvider.get();
            if (transaction != null && transaction.active() && transaction instanceof ConnectionProvider) {
                ConnectionProvider connectionProvider = (ConnectionProvider)((Object)transaction);
                connection = connectionProvider.getConnection();
            }
            if (connection == null) {
                connection = EntityDataStore.this.connectionProvider.getConnection();
                if (EntityDataStore.this.statementCache != null) {
                    connection = new StatementCachingConnection(EntityDataStore.this.statementCache, connection);
                }
            }
            Mapping mapping = EntityDataStore.this.mapping;
            synchronized (mapping) {
                if (EntityDataStore.this.platform == null) {
                    EntityDataStore.this.platform = new PlatformDelegate(connection);
                    EntityDataStore.this.platform.addMappings(EntityDataStore.this.mapping);
                }
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E extends T> EntityReader<E, T> read(Class<? extends E> type2) {
            ClassMap classMap = EntityDataStore.this.readers;
            synchronized (classMap) {
                EntityReader reader = (EntityReader)EntityDataStore.this.readers.get(type2);
                if (reader == null) {
                    EntityDataStore.this.checkConnectionMetadata();
                    reader = new EntityReader(EntityDataStore.this.entityModel.typeOf(type2), this, EntityDataStore.this);
                    EntityDataStore.this.readers.put(type2, reader);
                }
                return reader;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E extends T> EntityWriter<E, T> write(Class<? extends E> type2) {
            ClassMap classMap = EntityDataStore.this.writers;
            synchronized (classMap) {
                EntityWriter writer = (EntityWriter)EntityDataStore.this.writers.get(type2);
                if (writer == null) {
                    EntityDataStore.this.checkConnectionMetadata();
                    writer = new EntityWriter(EntityDataStore.this.entityModel.typeOf(type2), this, EntityDataStore.this);
                    EntityDataStore.this.writers.put(type2, writer);
                }
                return writer;
            }
        }

        @Override
        public CompositeEntityListener<T> getStateListener() {
            return EntityDataStore.this.stateListeners;
        }

        @Override
        public boolean supportsBatchUpdates() {
            EntityDataStore.this.checkConnectionMetadata();
            return EntityDataStore.this.supportsBatchUpdates && this.getBatchUpdateSize() > 0;
        }

        @Override
        public int getBatchUpdateSize() {
            return EntityDataStore.this.configuration.getBatchUpdateSize();
        }

        @Override
        public QueryBuilder.Options getQueryBuilderOptions() {
            EntityDataStore.this.checkConnectionMetadata();
            return EntityDataStore.this.queryOptions;
        }

        @Override
        public Mapping getMapping() {
            return EntityDataStore.this.mapping;
        }

        @Override
        public EntityModel getModel() {
            return EntityDataStore.this.entityModel;
        }

        @Override
        public EntityCache getCache() {
            return EntityDataStore.this.entityCache;
        }

        @Override
        public Platform getPlatform() {
            EntityDataStore.this.checkConnectionMetadata();
            return EntityDataStore.this.platform;
        }

        @Override
        public Generator<QueryElement<?>> getStatementGenerator() {
            if (EntityDataStore.this.statementGenerator == null) {
                EntityDataStore.this.statementGenerator = new StatementGenerator(this.getPlatform());
            }
            return EntityDataStore.this.statementGenerator;
        }

        @Override
        public StatementListener getStatementListener() {
            return EntityDataStore.this.statementListeners;
        }

        @Override
        public Set<Supplier<TransactionListener>> getTransactionListenerFactories() {
            return EntityDataStore.this.configuration.getTransactionListenerFactories();
        }

        @Override
        public TransactionProvider getTransactionProvider() {
            return EntityDataStore.this.transactionProvider;
        }

        @Override
        public TransactionMode getTransactionMode() {
            EntityDataStore.this.checkConnectionMetadata();
            return EntityDataStore.this.transactionMode;
        }

        @Override
        public TransactionIsolation getTransactionIsolation() {
            return EntityDataStore.this.configuration.getTransactionIsolation();
        }

        @Override
        public Executor getWriteExecutor() {
            return EntityDataStore.this.configuration.getWriteExecutor();
        }
    }
}

