/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class UByteValue
extends UnsignedValueConstant<Byte> {
    public UByteValue(byte byteValue) {
        super(byteValue);
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter(module, "module");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.uByte);
        SimpleType simpleType3 = simpleType2 = annotated == null ? null : annotated.getDefaultType();
        if (simpleType2 == null) {
            annotated = ErrorUtils.createErrorType("Unsigned type UByte not found");
            Intrinsics.checkNotNullExpressionValue(annotated, "createErrorType(\"Unsigned type UByte not found\")");
            kotlinType = (KotlinType)annotated;
        } else {
            kotlinType = simpleType2;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUByte()";
    }
}

