/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ietf.jgss.GSSCredential;
import org.postgresql.PGProperty;
import org.postgresql.core.PGStream;
import org.postgresql.gss.GSSCallbackHandler;
import org.postgresql.gss.GssAction;
import org.postgresql.gss.GssEncAction;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.internal.Nullness;

public class MakeGSS {
    private static final Logger LOGGER = Logger.getLogger(MakeGSS.class.getName());

    public static void authenticate(boolean encrypted, PGStream pgStream, String host2, String user, char @Nullable [] password, @Nullable String jaasApplicationName, @Nullable String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, PSQLException {
        Exception result2;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS");
        if (jaasApplicationName == null) {
            jaasApplicationName = PGProperty.JAAS_APPLICATION_NAME.getDefaultValue();
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            PrivilegedAction<Exception> action;
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(Nullness.castNonNull(jaasApplicationName), new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            if (encrypted) {
                action = new GssEncAction(pgStream, sub, host2, user, kerberosServerName, useSpnego, logServerErrorDetail);
                result2 = Subject.doAs(sub, action);
            } else {
                action = new GssAction(pgStream, sub, host2, user, kerberosServerName, useSpnego, logServerErrorDetail);
                result2 = Subject.doAs(sub, action);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result2 instanceof IOException) {
            throw (IOException)result2;
        }
        if (result2 instanceof PSQLException) {
            throw (PSQLException)result2;
        }
        if (result2 != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)result2);
        }
    }
}

