/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import io.requery.Nullable;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractEvent
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public String slug;
    public String currency;
    public Date date_from;
    @Nullable
    public Date date_to;
    public boolean live;
    public boolean has_subevents;
    @Column(definition="TEXT")
    public String json_data;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public boolean hasSeating() {
        try {
            return !this.getJSON().isNull("seating_plan");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public boolean hasPlugin(String plugin) {
        try {
            JSONArray plugins = this.getJSON().optJSONArray("plugins");
            for (int i = 0; i < plugins.length(); ++i) {
                if (!plugins.getString(i).equals(plugin)) continue;
                return true;
            }
        }
        catch (JSONException e) {
            return false;
        }
        return false;
    }

    public boolean isInTestmode() {
        try {
            return this.getJSON().optBoolean("testmode", false);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public String getName() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getTimezone() {
        try {
            return this.getJSON().optString("timezone", "UTC");
        }
        catch (JSONException e) {
            return "UTC";
        }
    }

    @org.jetbrains.annotations.Nullable
    public JSONObject getValidKeys() {
        try {
            return this.getJSON().optJSONObject("valid_keys");
        }
        catch (JSONException e) {
            return null;
        }
    }
}

