/*
 * Decompiled with CFR 0.152.
 */
package io.requery.reactivex;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.requery.BlockingEntityStore;
import io.requery.meta.Type;
import io.requery.meta.Types;
import io.requery.query.element.QueryElement;
import io.requery.reactivex.ReactiveEntityStore;
import io.requery.reactivex.ReactiveResult;
import io.requery.reactivex.TransactionListenerSupplier;
import io.requery.reactivex.WrappedEntityStore;
import java.util.Collections;
import java.util.Set;

public final class ReactiveSupport {
    private static final TransactionListenerSupplier typeChanges = new TransactionListenerSupplier();

    private ReactiveSupport() {
    }

    public static <S> ReactiveEntityStore<S> toReactiveStore(BlockingEntityStore<S> store) {
        return new WrappedEntityStore<S>(store);
    }

    static <T> Observable<ReactiveResult<T>> toObservableResult(final ReactiveResult<T> result2) {
        final QueryElement element = result2.unwrapQuery();
        result2.addTransactionListener(typeChanges);
        return typeChanges.commitSubject().filter(new Predicate<Set<Type<?>>>(){

            public boolean test(Set<Type<?>> types) {
                return !Collections.disjoint(element.entityTypes(), types) || Types.referencesType(element.entityTypes(), types);
            }
        }).map(new Function<Set<Type<?>>, ReactiveResult<T>>(){

            public ReactiveResult<T> apply(Set<Type<?>> types) {
                return result2;
            }
        }).startWith(result2);
    }
}

