/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.sql.Keyword;
import io.requery.util.function.Function;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;

public class QueryBuilder
implements CharSequence {
    private final StringBuilder sb;
    private final Options options;

    public QueryBuilder(Options options2) {
        this.options = options2;
        this.sb = new StringBuilder(32);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start2, int end) {
        return this.sb.subSequence(start2, end);
    }

    public QueryBuilder keyword(Keyword ... keywords) {
        for (Keyword keyword : keywords) {
            this.sb.append(this.options.lowercaseKeywords ? keyword.toString().toLowerCase(Locale.ROOT) : keyword);
            this.sb.append(" ");
        }
        return this;
    }

    public QueryBuilder appendIdentifier(String value, String identifier) {
        return this.append(identifier, false).append(value, false).append(identifier);
    }

    public QueryBuilder appendQuoted(String value) {
        return this.appendIdentifier(value, "'");
    }

    public QueryBuilder tableName(Object value) {
        String name = value.toString();
        if (this.options.tableTransformer != null) {
            name = (String)this.options.tableTransformer.apply(name);
        }
        if (this.options.quoteTableNames) {
            this.appendIdentifier(name, this.options.quotedIdentifier);
        } else {
            this.append(name);
        }
        return this.space();
    }

    public QueryBuilder tableNames(Iterable<Expression<?>> values2) {
        LinkedHashSet types = new LinkedHashSet();
        for (Expression<?> expression : values2) {
            if (expression.getExpressionType() != ExpressionType.ATTRIBUTE) continue;
            Attribute attribute = (Attribute)((Object)expression);
            types.add(attribute.getDeclaringType());
        }
        return this.commaSeparated(types, new Appender<Type<?>>(){

            @Override
            public void append(QueryBuilder qb, Type<?> value) {
                QueryBuilder.this.tableName(value.getName());
            }
        });
    }

    public QueryBuilder attribute(Attribute value) {
        String name;
        String string = name = this.options.columnTransformer == null ? value.getName() : (String)this.options.columnTransformer.apply(value.getName());
        if (this.options.quoteColumnNames) {
            this.appendIdentifier(name, this.options.quotedIdentifier);
        } else {
            this.append(name);
        }
        return this.space();
    }

    public QueryBuilder aliasAttribute(String alias, Attribute value) {
        this.append(alias);
        this.append(".");
        return this.attribute(value);
    }

    public QueryBuilder append(Object value) {
        return this.append(value, false);
    }

    public QueryBuilder value(Object value) {
        return this.append(value, true);
    }

    public QueryBuilder append(Object value, boolean space) {
        if (value == null) {
            this.keyword(Keyword.NULL);
        } else if (value instanceof String[]) {
            this.commaSeparated(Arrays.asList((String[])value));
        } else if (value instanceof Keyword) {
            this.sb.append(this.options.lowercaseKeywords ? value.toString().toLowerCase(Locale.ROOT) : value.toString());
        } else {
            this.sb.append(value.toString());
        }
        if (space) {
            this.sb.append(" ");
        }
        return this;
    }

    public <T> QueryBuilder appendWhereConditions(Set<Attribute<T, ?>> attributes) {
        int index = 0;
        for (Attribute<T, ?> attribute : attributes) {
            if (index > 0) {
                this.keyword(Keyword.AND);
                this.space();
            }
            this.attribute(attribute);
            this.space();
            this.append("=?");
            this.space();
            ++index;
        }
        return this;
    }

    public QueryBuilder commaSeparatedExpressions(Iterable<Expression<?>> values2) {
        return this.commaSeparated(values2, new Appender<Expression<?>>(){

            @Override
            public void append(QueryBuilder qb, Expression<?> value) {
                switch (value.getExpressionType()) {
                    case ATTRIBUTE: {
                        qb.attribute((Attribute)((Object)value));
                        break;
                    }
                    default: {
                        qb.append(value.getName()).space();
                    }
                }
            }
        });
    }

    public QueryBuilder commaSeparatedAttributes(Iterable<? extends Attribute<?, ?>> values2) {
        return this.commaSeparated(values2, new Appender<Attribute<?, ?>>(){

            @Override
            public void append(QueryBuilder qb, Attribute<?, ?> value) {
                qb.attribute(value);
            }
        });
    }

    public <T> QueryBuilder commaSeparated(Iterable<? extends T> values2) {
        return this.commaSeparated(values2, null);
    }

    public <T> QueryBuilder commaSeparated(Iterable<? extends T> values2, Appender<T> appender) {
        return this.commaSeparated(values2.iterator(), appender);
    }

    public <T> QueryBuilder commaSeparated(Iterator<? extends T> values2, Appender<T> appender) {
        int i = 0;
        while (values2.hasNext()) {
            T value = values2.next();
            if (i > 0) {
                this.comma();
            }
            if (appender == null) {
                this.append(value);
            } else {
                appender.append(this, value);
            }
            ++i;
        }
        return this;
    }

    public QueryBuilder openParenthesis() {
        this.sb.append("(");
        return this;
    }

    public QueryBuilder closeParenthesis() {
        if (this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.setCharAt(this.sb.length() - 1, ')');
        } else {
            this.sb.append(')');
        }
        return this;
    }

    public QueryBuilder space() {
        if (this.sb.charAt(this.sb.length() - 1) != ' ') {
            this.sb.append(" ");
        }
        return this;
    }

    public QueryBuilder comma() {
        if (this.sb.charAt(this.sb.length() - 1) == ' ') {
            this.sb.setCharAt(this.sb.length() - 1, ',');
        } else {
            this.sb.append(',');
        }
        this.space();
        return this;
    }

    public static class Options {
        private final String quotedIdentifier;
        private final Function<String, String> tableTransformer;
        private final Function<String, String> columnTransformer;
        private final boolean lowercaseKeywords;
        private final boolean quoteTableNames;
        private final boolean quoteColumnNames;

        public Options(String quotedIdentifier, boolean lowercaseKeywords, Function<String, String> tableTransformer, Function<String, String> columnTransformer, boolean quoteTableNames, boolean quoteColumnNames) {
            if (quotedIdentifier.equals(" ")) {
                quotedIdentifier = "\"";
            }
            this.quotedIdentifier = quotedIdentifier;
            this.tableTransformer = tableTransformer;
            this.columnTransformer = columnTransformer;
            this.lowercaseKeywords = lowercaseKeywords;
            this.quoteTableNames = quoteTableNames;
            this.quoteColumnNames = quoteColumnNames;
        }
    }

    public static interface Appender<T> {
        public void append(QueryBuilder var1, T var2);
    }
}

