/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.sql.BaseType;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.QueryBuilder;
import io.requery.sql.VersionColumnDefinition;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.LimitGenerator;
import io.requery.sql.gen.Output;
import io.requery.sql.platform.Generic;
import io.requery.sql.type.VarCharType;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import javax.sql.rowset.serial.SerialBlob;

public class PostgresSQL
extends Generic {
    private final SerialColumnDefinition serialColumnDefinition = new SerialColumnDefinition();
    private final VersionColumnDefinition versionColumnDefinition = new SystemVersionColumnDefinition();

    @Override
    public boolean supportsInlineForeignKeyReference() {
        return true;
    }

    @Override
    public boolean supportsGeneratedKeysInBatchUpdate() {
        return true;
    }

    @Override
    public GeneratedColumnDefinition generatedColumnDefinition() {
        return this.serialColumnDefinition;
    }

    @Override
    public void addMappings(Mapping mapping) {
        super.addMappings(mapping);
        mapping.replaceType(-2, new ByteArrayType(-2));
        mapping.replaceType(-3, new ByteArrayType(-3));
        mapping.replaceType(-9, new VarCharType());
        mapping.replaceType(2004, new BlobType());
        mapping.replaceType(2000, new UUIDType());
    }

    public LimitGenerator limitGenerator() {
        return new LimitGenerator();
    }

    @Override
    public VersionColumnDefinition versionColumnDefinition() {
        return this.versionColumnDefinition;
    }

    @Override
    public Generator<Map<Expression<?>, Object>> upsertGenerator() {
        return new UpsertOnConflictDoUpdate();
    }

    private static class UpsertOnConflictDoUpdate
    implements Generator<Map<Expression<?>, Object>> {
        private UpsertOnConflictDoUpdate() {
        }

        @Override
        public void write(final Output output, final Map<Expression<?>, Object> values2) {
            QueryBuilder qb = output.builder();
            Type type2 = ((Attribute)((Object)values2.keySet().iterator().next())).getDeclaringType();
            qb.keyword(Keyword.INSERT, Keyword.INTO).tableNames(values2.keySet()).openParenthesis().commaSeparatedExpressions(values2.keySet()).closeParenthesis().space().keyword(Keyword.VALUES).openParenthesis().commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression expression) {
                    qb.append("?");
                    output.parameters().add(expression, values2.get(expression));
                }
            }).closeParenthesis().space().keyword(Keyword.ON, Keyword.CONFLICT).openParenthesis().commaSeparatedAttributes(type2.getKeyAttributes()).closeParenthesis().space().keyword(Keyword.DO, Keyword.UPDATE, Keyword.SET).commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    qb.attribute((Attribute)((Object)value));
                    qb.append("= EXCLUDED." + value.getName());
                }
            });
        }
    }

    private static class SystemVersionColumnDefinition
    implements VersionColumnDefinition {
        private SystemVersionColumnDefinition() {
        }

        @Override
        public boolean createColumn() {
            return false;
        }

        @Override
        public String columnName() {
            return "xmin";
        }
    }

    private static class SerialColumnDefinition
    implements GeneratedColumnDefinition {
        private SerialColumnDefinition() {
        }

        @Override
        public boolean skipTypeIdentifier() {
            return true;
        }

        @Override
        public boolean postFixPrimaryKey() {
            return false;
        }

        @Override
        public void appendGeneratedSequence(QueryBuilder qb, Attribute attribute) {
            qb.append("serial");
        }
    }

    private static class UUIDType
    extends BaseType<UUID> {
        UUIDType() {
            super(UUID.class, 2000);
        }

        @Override
        public String getIdentifier() {
            return "uuid";
        }

        @Override
        public void write(PreparedStatement statement, int index, UUID value) throws SQLException {
            statement.setObject(index, value);
        }
    }

    private static class ByteArrayType
    extends BaseType<byte[]> {
        ByteArrayType(int jdbcType) {
            super(byte[].class, jdbcType);
        }

        @Override
        public String getIdentifier() {
            return "bytea";
        }

        @Override
        public byte[] read(ResultSet results, int column) throws SQLException {
            byte[] value = results.getBytes(column);
            return results.wasNull() ? null : value;
        }
    }

    private static class BlobType
    extends BaseType<Blob> {
        BlobType() {
            super(Blob.class, -3);
        }

        @Override
        public String getIdentifier() {
            return "bytea";
        }

        @Override
        public Blob read(ResultSet results, int column) throws SQLException {
            byte[] value = results.getBytes(column);
            return results.wasNull() ? null : new SerialBlob(value);
        }

        @Override
        public void write(PreparedStatement statement, int index, Blob value) throws SQLException {
            if (value == null) {
                statement.setNull(index, -3);
            } else {
                statement.setBinaryStream(index, value.getBinaryStream(), value.length());
            }
        }
    }
}

