/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.db.RevokedTicketSecret;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RevokedTicketSecretSyncAdapter
extends BaseDownloadSyncAdapter<RevokedTicketSecret, Long> {
    private String firstResponseTimestamp;
    private ResourceSyncStatus rlm;

    public RevokedTicketSecretSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        boolean completed = false;
        try {
            super.download();
            completed = true;
        }
        finally {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
            if (this.firstResponseTimestamp != null) {
                if (resourceSyncStatus == null) {
                    resourceSyncStatus = new ResourceSyncStatus();
                    resourceSyncStatus.setResource(this.getResourceName());
                    resourceSyncStatus.setEvent_slug(this.eventSlug);
                    if (completed) {
                        resourceSyncStatus.setStatus("complete");
                        resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                        this.store.upsert(resourceSyncStatus);
                    }
                } else if (completed) {
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                }
            } else if (completed && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("complete");
                this.store.update(resourceSyncStatus);
            }
            this.firstResponseTimestamp = null;
        }
    }

    @Override
    protected boolean deleteUnseen() {
        return this.rlm == null;
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(RevokedTicketSecret.SERVER_ID).where(RevokedTicketSecret.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    public void updateObject(RevokedTicketSecret obj, JSONObject jsonobj) throws JSONException {
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setCreated(jsonobj.getString("created"));
        obj.setSecret(jsonobj.getString("secret"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    protected String getUrl() {
        return this.api.eventResourceUrl(this.eventSlug, this.getResourceName());
    }

    @Override
    String getResourceName() {
        return "revokedsecrets";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(RevokedTicketSecret obj) {
        return obj.getServer_id();
    }

    @Override
    RevokedTicketSecret newEmptyObject() {
        return new RevokedTicketSecret();
    }

    @Override
    public CloseableIterator<RevokedTicketSecret> runBatch(List<Long> parameterBatch) {
        return ((Result)((WhereAndOr)this.store.select(RevokedTicketSecret.class, new QueryAttribute[0]).where(RevokedTicketSecret.SERVER_ID.in(parameterBatch)).and(RevokedTicketSecret.EVENT_SLUG.eq((Object)this.eventSlug))).get()).iterator();
    }

    @Override
    protected JSONObject downloadPage(String url2, boolean isFirstPage) throws ApiException, ResourceNotModified {
        if (isFirstPage) {
            this.rlm = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
        }
        if (this.rlm != null) {
            try {
                if (!url2.contains("created_since")) {
                    url2 = url2.contains("?") ? url2 + "&" : url2 + "?";
                    url2 = url2 + "ordering=-created&created_since=" + URLEncoder.encode(this.rlm.getLast_modified(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url2);
        if (isFirstPage) {
            try {
                JSONArray results = apiResponse.getData().getJSONArray("results");
                if (results.length() > 0) {
                    this.firstResponseTimestamp = results.getJSONObject(0).getString("created");
                }
            }
            catch (NullPointerException | JSONException e) {
                e.printStackTrace();
            }
        }
        return apiResponse.getData();
    }
}

