/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    private static Set<String> setFromIterable(Iterator<String> it) {
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            set.add(it.next());
        }
        return set;
    }

    public static boolean similar(JSONObject first, Object other) {
        if (first == null && other == null) {
            return true;
        }
        if (first == null || !(other instanceof JSONObject)) {
            return false;
        }
        Set<String> set = JSONUtils.setFromIterable(first.keys());
        if (!set.equals(JSONUtils.setFromIterable(((JSONObject)other).keys()))) {
            return false;
        }
        try {
            for (String name : set) {
                Object valueThis = first.get(name);
                Object valueOther = ((JSONObject)other).get(name);
                if (!(valueThis instanceof JSONObject ? !JSONUtils.similar((JSONObject)valueThis, valueOther) : (valueThis instanceof JSONArray ? !JSONUtils.similar((JSONArray)valueThis, valueOther) : !valueThis.equals(valueOther)))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    public static boolean similar(JSONArray first, Object other) {
        int otherlen;
        if (!(other instanceof JSONArray)) {
            return false;
        }
        int firstlen = first.length();
        if (firstlen != (otherlen = ((JSONArray)other).length())) {
            return false;
        }
        try {
            for (int i = 0; i < firstlen; ++i) {
                Object valueThis = first.get(i);
                Object valueOther = ((JSONArray)other).get(i);
                if (!(valueThis instanceof JSONObject ? !JSONUtils.similar((JSONObject)valueThis, valueOther) : (valueThis instanceof JSONArray ? !JSONUtils.similar((JSONArray)valueThis, valueOther) : !valueThis.equals(valueOther)))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }
}

