/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.meta.Type;
import io.requery.sql.EntityTransaction;
import io.requery.util.function.Supplier;
import java.util.Set;

class TransactionScope
implements AutoCloseable {
    private final EntityTransaction transaction;
    private final boolean enteredTransaction;

    TransactionScope(Supplier<? extends EntityTransaction> supplier) {
        this(supplier, null);
    }

    TransactionScope(Supplier<? extends EntityTransaction> supplier, Set<Type<?>> types) {
        this.transaction = supplier.get();
        if (!this.transaction.active()) {
            this.transaction.begin();
            this.enteredTransaction = true;
        } else {
            this.enteredTransaction = false;
        }
        if (types != null) {
            this.transaction.addToTransaction(types);
        }
    }

    public void commit() {
        if (this.enteredTransaction) {
            this.transaction.commit();
        }
    }

    @Override
    public void close() {
        if (this.enteredTransaction) {
            this.transaction.close();
        }
    }
}

