/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.IntSummaryStatistics;
import java8.util.Objects;
import java8.util.OptionalDouble;
import java8.util.OptionalInt;
import java8.util.PrimitiveIterator;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.BiConsumer;
import java8.util.function.BinaryOperator;
import java8.util.function.IntBinaryOperator;
import java8.util.function.IntConsumer;
import java8.util.function.IntFunction;
import java8.util.function.IntPredicate;
import java8.util.function.IntToDoubleFunction;
import java8.util.function.IntToLongFunction;
import java8.util.function.IntUnaryOperator;
import java8.util.function.ObjIntConsumer;
import java8.util.function.Supplier;
import java8.util.stream.AbstractPipeline;
import java8.util.stream.BaseStream;
import java8.util.stream.Collectors;
import java8.util.stream.DoublePipeline;
import java8.util.stream.DoubleStream;
import java8.util.stream.FindOps;
import java8.util.stream.ForEachOps;
import java8.util.stream.IntPipeline$$Lambda$1;
import java8.util.stream.IntPipeline$$Lambda$10;
import java8.util.stream.IntPipeline$$Lambda$11;
import java8.util.stream.IntPipeline$$Lambda$12;
import java8.util.stream.IntPipeline$$Lambda$2;
import java8.util.stream.IntPipeline$$Lambda$3;
import java8.util.stream.IntPipeline$$Lambda$4;
import java8.util.stream.IntPipeline$$Lambda$5;
import java8.util.stream.IntPipeline$$Lambda$6;
import java8.util.stream.IntPipeline$$Lambda$7;
import java8.util.stream.IntPipeline$$Lambda$8;
import java8.util.stream.IntPipeline$$Lambda$9;
import java8.util.stream.IntPipeline$7$1$$Lambda$1;
import java8.util.stream.IntStream;
import java8.util.stream.LongPipeline;
import java8.util.stream.LongStream;
import java8.util.stream.MatchOps;
import java8.util.stream.Node;
import java8.util.stream.Nodes;
import java8.util.stream.PipelineHelper;
import java8.util.stream.ReduceOps;
import java8.util.stream.ReferencePipeline;
import java8.util.stream.Sink;
import java8.util.stream.SliceOps;
import java8.util.stream.SortedOps;
import java8.util.stream.Stream;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.WhileOps;

abstract class IntPipeline<E_IN>
extends AbstractPipeline<E_IN, Integer, IntStream>
implements IntStream {
    IntPipeline(Supplier<? extends Spliterator<Integer>> source2, int sourceFlags, boolean parallel) {
        super(source2, sourceFlags, parallel);
    }

    IntPipeline(Spliterator<Integer> source2, int sourceFlags, boolean parallel) {
        super(source2, sourceFlags, parallel);
    }

    IntPipeline(AbstractPipeline<?, E_IN, ?> upstream, int opFlags) {
        super(upstream, opFlags);
    }

    private static IntConsumer adapt(Sink<Integer> sink2) {
        if (sink2 instanceof IntConsumer) {
            return (IntConsumer)((Object)sink2);
        }
        Sink<Integer> sink3 = sink2;
        sink3.getClass();
        return IntPipeline$$Lambda$1.lambdaFactory$(sink3);
    }

    static Spliterator.OfInt adapt(Spliterator<Integer> s2) {
        if (s2 instanceof Spliterator.OfInt) {
            return (Spliterator.OfInt)s2;
        }
        throw new UnsupportedOperationException("IntStream.adapt(Spliterator<Integer> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.INT_VALUE;
    }

    @Override
    final <P_IN> Node<Integer> evaluateToNode(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator, boolean flattenTree, IntFunction<Integer[]> generator) {
        return Nodes.collectInt(helper, spliterator, flattenTree);
    }

    @Override
    final <P_IN> Spliterator<Integer> wrap(PipelineHelper<Integer> ph, Supplier<Spliterator<P_IN>> supplier, boolean isParallel) {
        return new StreamSpliterators.IntWrappingSpliterator<P_IN>(ph, supplier, isParallel);
    }

    final Spliterator.OfInt lazySpliterator(Supplier<? extends Spliterator<Integer>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfInt((Supplier<Spliterator.OfInt>)supplier);
    }

    @Override
    final boolean forEachWithCancel(Spliterator<Integer> spliterator, Sink<Integer> sink2) {
        boolean cancelled;
        Spliterator.OfInt spl = IntPipeline.adapt(spliterator);
        IntConsumer adaptedSink = IntPipeline.adapt(sink2);
        while (!(cancelled = sink2.cancellationRequested()) && spl.tryAdvance(adaptedSink)) {
        }
        return cancelled;
    }

    @Override
    final Node.Builder<Integer> makeNodeBuilder(long exactSizeIfKnown, IntFunction<Integer[]> generator) {
        return Nodes.intBuilder(exactSizeIfKnown);
    }

    private <U> Stream<U> mapToObj(final IntFunction<? extends U> mapper2, int opFlags) {
        return new ReferencePipeline.StatelessOp<Integer, U>(this, StreamShape.INT_VALUE, opFlags){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<U> sink2) {
                return new Sink.ChainedInt<U>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept(mapper2.apply(t));
                    }
                };
            }
        };
    }

    @Override
    public final PrimitiveIterator.OfInt iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfInt spliterator() {
        return IntPipeline.adapt(super.spliterator());
    }

    @Override
    public final LongStream asLongStream() {
        return new LongPipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, 0){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Long> sink2) {
                return new Sink.ChainedInt<Long>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept((long)t);
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, 0){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Double> sink2) {
                return new Sink.ChainedInt<Double>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept((double)t);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<Integer> boxed() {
        return this.mapToObj(IntPipeline$$Lambda$2.lambdaFactory$(), 0);
    }

    @Override
    public final IntStream map(final IntUnaryOperator mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedInt<Integer>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept(mapper2.applyAsInt(t));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(IntFunction<? extends U> mapper2) {
        Objects.requireNonNull(mapper2);
        return this.mapToObj(mapper2, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT);
    }

    @Override
    public final LongStream mapToLong(final IntToLongFunction mapper2) {
        Objects.requireNonNull(mapper2);
        return new LongPipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Long> sink2) {
                return new Sink.ChainedInt<Long>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept(mapper2.applyAsLong(t));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final IntToDoubleFunction mapper2) {
        Objects.requireNonNull(mapper2);
        return new DoublePipeline.StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Double> sink2) {
                return new Sink.ChainedInt<Double>(sink2){

                    @Override
                    public void accept(int t) {
                        this.downstream.accept(mapper2.applyAsDouble(t));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream flatMap(final IntFunction<? extends IntStream> mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedInt<Integer>(sink2){
                    boolean cancellationRequested;
                    IntConsumer downstreamAsInt;
                    {
                        Sink sink2 = this.downstream;
                        sink2.getClass();
                        this.downstreamAsInt = IntPipeline$7$1$$Lambda$1.lambdaFactory$(sink2);
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(int t) {
                        BaseStream result2 = null;
                        try {
                            result2 = (IntStream)mapper2.apply(t);
                            if (result2 != null) {
                                if (!this.cancellationRequested) {
                                    result2.sequential().forEach(this.downstreamAsInt);
                                } else {
                                    Spliterator.OfInt s2 = result2.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s2.tryAdvance(this.downstreamAsInt)) {
                                    }
                                }
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapMulti(final IntStream.IntMapMultiConsumer mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedInt<Integer>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(int t) {
                        mapper2.accept(t, (IntConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public IntStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return sink2;
            }
        };
    }

    @Override
    public final IntStream filter(final IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedInt<Integer>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(int t) {
                        if (predicate.test(t)) {
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final IntStream peek(final IntConsumer action) {
        Objects.requireNonNull(action);
        return new StatelessOp<Integer>((AbstractPipeline)this, StreamShape.INT_VALUE, 0){

            @Override
            Sink<Integer> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedInt<Integer>(sink2){

                    @Override
                    public void accept(int t) {
                        action.accept(t);
                        this.downstream.accept(t);
                    }
                };
            }
        };
    }

    @Override
    public final IntStream limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        return SliceOps.makeInt(this, 0L, maxSize);
    }

    @Override
    public final IntStream skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        if (n == 0L) {
            return this;
        }
        return SliceOps.makeInt(this, n, -1L);
    }

    @Override
    public final IntStream takeWhile(IntPredicate predicate) {
        return WhileOps.makeTakeWhileInt(this, predicate);
    }

    @Override
    public final IntStream dropWhile(IntPredicate predicate) {
        return WhileOps.makeDropWhileInt(this, predicate);
    }

    @Override
    public final IntStream sorted() {
        return SortedOps.makeInt(this);
    }

    @Override
    public final IntStream distinct() {
        return this.boxed().distinct().mapToInt(IntPipeline$$Lambda$3.lambdaFactory$());
    }

    @Override
    public void forEach(IntConsumer action) {
        this.evaluate(ForEachOps.makeInt(action, false));
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.evaluate(ForEachOps.makeInt(action, true));
    }

    @Override
    public final int sum() {
        return this.reduce(0, IntPipeline$$Lambda$4.lambdaFactory$());
    }

    @Override
    public final OptionalInt min() {
        return this.reduce(IntPipeline$$Lambda$5.lambdaFactory$());
    }

    @Override
    public final OptionalInt max() {
        return this.reduce(IntPipeline$$Lambda$6.lambdaFactory$());
    }

    @Override
    public final long count() {
        return this.evaluate(ReduceOps.makeIntCounting());
    }

    @Override
    public final OptionalDouble average() {
        long[] avg = (long[])this.collect(IntPipeline$$Lambda$7.lambdaFactory$(), IntPipeline$$Lambda$8.lambdaFactory$(), IntPipeline$$Lambda$9.lambdaFactory$());
        return avg[0] > 0L ? OptionalDouble.of((double)avg[1] / (double)avg[0]) : OptionalDouble.empty();
    }

    @Override
    public final IntSummaryStatistics summaryStatistics() {
        return this.collect(Collectors.INT_SUM_STATS, IntPipeline$$Lambda$10.lambdaFactory$(), IntPipeline$$Lambda$11.lambdaFactory$());
    }

    @Override
    public final int reduce(int identity, IntBinaryOperator op) {
        return this.evaluate(ReduceOps.makeInt(identity, op));
    }

    @Override
    public final OptionalInt reduce(IntBinaryOperator op) {
        return this.evaluate(ReduceOps.makeInt(op));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(combiner);
        BinaryOperator operator = IntPipeline$$Lambda$12.lambdaFactory$(combiner);
        return this.evaluate(ReduceOps.makeInt(supplier, accumulator, operator));
    }

    @Override
    public final boolean anyMatch(IntPredicate predicate) {
        return this.evaluate(MatchOps.makeInt(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(IntPredicate predicate) {
        return this.evaluate(MatchOps.makeInt(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(IntPredicate predicate) {
        return this.evaluate(MatchOps.makeInt(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalInt findFirst() {
        return this.evaluate(FindOps.makeInt(true));
    }

    @Override
    public final OptionalInt findAny() {
        return this.evaluate(FindOps.makeInt(false));
    }

    @Override
    public final int[] toArray() {
        return (int[])Nodes.flattenInt((Node.OfInt)this.evaluateToArrayNode(WhileOps.INT_ARR_GEN)).asPrimitiveArray();
    }

    static /* synthetic */ Object lambda$collect$98(BiConsumer biConsumer, Object left, Object right) {
        biConsumer.accept(left, right);
        return left;
    }

    static /* synthetic */ void lambda$average$97(long[] ll, long[] rr) {
        ll[0] = ll[0] + rr[0];
        ll[1] = ll[1] + rr[1];
    }

    static /* synthetic */ void lambda$average$96(long[] ll, int i) {
        ll[0] = ll[0] + 1L;
        ll[1] = ll[1] + (long)i;
    }

    static /* synthetic */ long[] lambda$average$95() {
        return new long[2];
    }

    static /* synthetic */ int lambda$distinct$94(Integer i) {
        return i;
    }

    static abstract class StatefulOp<E_IN>
    extends IntPipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> var1, Spliterator<P_IN> var2, IntFunction<Integer[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends IntPipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN>
    extends IntPipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Integer>> source2, int sourceFlags, boolean parallel) {
            super(source2, sourceFlags, parallel);
        }

        Head(Spliterator<Integer> source2, int sourceFlags, boolean parallel) {
            super(source2, sourceFlags, parallel);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int flags, Sink<Integer> sink2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(IntConsumer action) {
            if (!this.isParallel()) {
                Head.adapt(this.sourceStageSpliterator()).forEachRemaining(action);
            } else {
                super.forEach(action);
            }
        }

        @Override
        public void forEachOrdered(IntConsumer action) {
            if (!this.isParallel()) {
                Head.adapt(this.sourceStageSpliterator()).forEachRemaining(action);
            } else {
                super.forEachOrdered(action);
            }
        }
    }
}

