/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.db.SubEvent;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class AllSubEventsSyncAdapter
extends BaseDownloadSyncAdapter<SubEvent, Long> {
    private String firstResponseTimestamp;
    private ResourceSyncStatus rlm;

    public AllSubEventsSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, "__all__", api, syncCycleId, feedback);
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        boolean completed = false;
        try {
            super.download();
            completed = true;
        }
        finally {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)"subevents")).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)"__all__"))).limit(1).get()).firstOrNull();
            if (this.firstResponseTimestamp != null) {
                if (resourceSyncStatus == null) {
                    resourceSyncStatus = new ResourceSyncStatus();
                    resourceSyncStatus.setResource("subevents");
                    resourceSyncStatus.setEvent_slug("__all__");
                    if (completed) {
                        resourceSyncStatus.setStatus("complete");
                        resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                        this.store.upsert(resourceSyncStatus);
                    }
                } else if (completed) {
                    resourceSyncStatus.setLast_modified(this.firstResponseTimestamp);
                    this.store.upsert(resourceSyncStatus);
                }
            } else if (completed && resourceSyncStatus != null) {
                resourceSyncStatus.setStatus("complete");
                this.store.update(resourceSyncStatus);
            }
            this.firstResponseTimestamp = null;
        }
    }

    @Override
    protected boolean deleteUnseen() {
        return this.rlm == null;
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(SubEvent.SERVER_ID).get()).iterator();
    }

    @Override
    public void updateObject(SubEvent obj, JSONObject jsonobj) throws JSONException {
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setEvent_slug(jsonobj.getString("event"));
        obj.setDate_from(ISODateTimeFormat.dateTimeParser().parseDateTime(jsonobj.getString("date_from")).toDate());
        if (!jsonobj.isNull("date_to")) {
            obj.setDate_to(ISODateTimeFormat.dateTimeParser().parseDateTime(jsonobj.getString("date_to")).toDate());
        }
        obj.setActive(jsonobj.getBoolean("active"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    protected String getUrl() {
        return this.api.organizerResourceUrl(this.getResourceName());
    }

    @Override
    String getResourceName() {
        return "subevents";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(SubEvent obj) {
        return obj.getServer_id();
    }

    @Override
    SubEvent newEmptyObject() {
        return new SubEvent();
    }

    @Override
    public CloseableIterator<SubEvent> runBatch(List<Long> parameterBatch) {
        return ((Result)this.store.select(SubEvent.class, new QueryAttribute[0]).where(SubEvent.SERVER_ID.in(parameterBatch)).get()).iterator();
    }

    @Override
    protected JSONObject downloadPage(String url2, boolean isFirstPage) throws ApiException, ResourceNotModified {
        if (isFirstPage) {
            this.rlm = (ResourceSyncStatus)((Result)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)"subevents")).limit(1).get()).firstOrNull();
        }
        if (this.rlm != null) {
            try {
                if (!url2.contains("modified_since")) {
                    url2 = url2.contains("?") ? url2 + "&" : url2 + "?";
                    url2 = url2 + "ordering=-last_modified&modified_since=" + URLEncoder.encode(this.rlm.getLast_modified(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url2);
        if (isFirstPage) {
            this.firstResponseTimestamp = apiResponse.getResponse().header("X-Page-Generated");
        }
        return apiResponse.getData();
    }
}

