/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.CachedPdfImage;
import eu.pretix.libpretixsync.db.Event;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.db.SubEvent;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SubEventSyncAdapter;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.RollbackException;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.Expression;
import io.requery.query.JoinWhereGroupByOrderBy;
import io.requery.query.Limit;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Selection;
import io.requery.query.SetHavingOrderByLimit;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.json.JSONException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\f\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u001e\u001a\u00020\u001f2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0!J\u0006\u0010\"\u001a\u00020\u001fJ\u001d\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\n2\b\u0010%\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010,R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Leu/pretix/libpretixsync/sync/OrderCleanup;", "", "store", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "fileStorage", "Leu/pretix/libpretixsync/sync/FileStorage;", "api", "Leu/pretix/libpretixsync/api/PretixApi;", "syncCycleId", "", "feedback", "Leu/pretix/libpretixsync/sync/SyncManager$ProgressFeedback;", "(Lio/requery/BlockingEntityStore;Leu/pretix/libpretixsync/sync/FileStorage;Leu/pretix/libpretixsync/api/PretixApi;Ljava/lang/String;Leu/pretix/libpretixsync/sync/SyncManager$ProgressFeedback;)V", "getApi", "()Leu/pretix/libpretixsync/api/PretixApi;", "eventsDeletionDate", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getFeedback", "()Leu/pretix/libpretixsync/sync/SyncManager$ProgressFeedback;", "getFileStorage", "()Leu/pretix/libpretixsync/sync/FileStorage;", "getStore", "()Lio/requery/BlockingEntityStore;", "subeventsDeletionDate", "", "getSyncCycleId", "()Ljava/lang/String;", "deleteOldEvents", "", "keepSlugs", "", "deleteOldPdfImages", "deleteOldSubevents", "eventSlug", "subeventId", "(Ljava/lang/String;Ljava/lang/Long;)V", "deletionTimeForEvent", "slug", "(Ljava/lang/String;)Ljava/lang/Long;", "deletionTimeForSubevent", "sid", "(JLjava/lang/String;)Ljava/lang/Long;", "libpretixsync"})
public final class OrderCleanup {
    @NotNull
    private final BlockingEntityStore<Persistable> store;
    @NotNull
    private final FileStorage fileStorage;
    @NotNull
    private final PretixApi api;
    @NotNull
    private final String syncCycleId;
    @Nullable
    private final SyncManager.ProgressFeedback feedback;
    @NotNull
    private Map<Long, Long> subeventsDeletionDate;
    @NotNull
    private HashMap<String, Long> eventsDeletionDate;

    public OrderCleanup(@NotNull BlockingEntityStore<Persistable> store, @NotNull FileStorage fileStorage2, @NotNull PretixApi api, @NotNull String syncCycleId, @Nullable SyncManager.ProgressFeedback feedback) {
        Intrinsics.checkNotNullParameter(store, "store");
        Intrinsics.checkNotNullParameter(fileStorage2, "fileStorage");
        Intrinsics.checkNotNullParameter(api, "api");
        Intrinsics.checkNotNullParameter(syncCycleId, "syncCycleId");
        this.store = store;
        this.fileStorage = fileStorage2;
        this.api = api;
        this.syncCycleId = syncCycleId;
        this.feedback = feedback;
        this.subeventsDeletionDate = new HashMap();
        this.eventsDeletionDate = new HashMap();
    }

    @NotNull
    public final BlockingEntityStore<Persistable> getStore() {
        return this.store;
    }

    @NotNull
    public final FileStorage getFileStorage() {
        return this.fileStorage;
    }

    @NotNull
    public final PretixApi getApi() {
        return this.api;
    }

    @NotNull
    public final String getSyncCycleId() {
        return this.syncCycleId;
    }

    @Nullable
    public final SyncManager.ProgressFeedback getFeedback() {
        return this.feedback;
    }

    private final Long deletionTimeForSubevent(long sid, String eventSlug) {
        if (this.subeventsDeletionDate.containsKey(sid)) {
            return this.subeventsDeletionDate.get(sid);
        }
        try {
            new SubEventSyncAdapter(this.store, eventSlug, String.valueOf(sid), this.api, this.syncCycleId, OrderCleanup::deletionTimeForSubevent$lambda$0).download();
        }
        catch (RollbackException e) {
            Long l = sid;
            this.subeventsDeletionDate.put(l, null);
            return null;
        }
        catch (JSONException e) {
            Long l = sid;
            this.subeventsDeletionDate.put(l, null);
            return null;
        }
        catch (ApiException e) {
            Long l = sid;
            this.subeventsDeletionDate.put(l, null);
            return null;
        }
        SubEvent se = (SubEvent)((Result)this.store.select(SubEvent.class, new QueryAttribute[0]).where((Condition)SubEvent.SERVER_ID.eq((Object)sid)).get()).firstOrNull();
        if (se == null) {
            Long l = sid;
            this.subeventsDeletionDate.put(l, null);
            return null;
        }
        DateTime d = new DateTime(se.getDate_to() != null ? se.getDate_to() : se.getDate_from());
        long v = d.plus(Duration.standardDays(14L)).getMillis();
        Long l = sid;
        Long l2 = v;
        this.subeventsDeletionDate.put(l, l2);
        return v;
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteOldSubevents(@NotNull String eventSlug, @Nullable Long subeventId) {
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        if (subeventId == null || subeventId < 1L) {
            return;
        }
        Object e = ((Scalar)((WhereAndOr)this.store.count(Order.class).where((Condition)Order.EVENT_SLUG.eq((Object)eventSlug)).and((Condition)Order.DELETE_AFTER_TIMESTAMP.isNull().or((Condition)Order.DELETE_AFTER_TIMESTAMP.lt((Object)1L)))).get()).value();
        Intrinsics.checkNotNullExpressionValue(e, "store.count(Order::class\u2026           .get().value()");
        int ordercount = ((Number)e).intValue();
        int done = 0;
        SyncManager.ProgressFeedback progressFeedback = this.feedback;
        if (progressFeedback != null) {
            progressFeedback.postFeedback("Checking for old orders (" + done + '/' + ordercount + ") [" + eventSlug + "] \u2026");
        }
        block2: while (true) {
            List orders;
            Intrinsics.checkNotNullExpressionValue(((Result)((WhereAndOr)this.store.select(Order.class, new QueryAttribute[0]).where((Condition)Order.EVENT_SLUG.eq((Object)eventSlug)).and((Condition)Order.DELETE_AFTER_TIMESTAMP.isNull().or((Condition)Order.DELETE_AFTER_TIMESTAMP.lt((Object)1L)))).limit(100).get()).toList(), "store.select(Order::clas\u2026          .get().toList()");
            if (orders.isEmpty()) break;
            Iterator iterator2 = orders.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block2;
                Order o = (Order)iterator2.next();
                Long deltime = null;
                try {
                    void $this$mapTo$iv$iv;
                    Object[] objectArray = new Expression[]{OrderPosition.SUBEVENT_ID};
                    Selection<Result<Tuple>> selection = this.store.select((Expression<?>[])objectArray);
                    objectArray = new Class[]{OrderPosition.class};
                    List list = ((Result)selection.from((Class<?>[])objectArray).where((Condition)OrderPosition.ORDER_ID.eq(o.id)).get()).toList();
                    Intrinsics.checkNotNullExpressionValue(list, "store.select(OrderPositi\u2026          .get().toList()");
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Tuple tuple = (Tuple)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((Long)it.get(0));
                    }
                    List<Long> subeventIds = CollectionsKt.distinct((List)destination$iv$iv);
                    if (subeventIds.isEmpty()) {
                        deltime = System.currentTimeMillis();
                    }
                    for (Long sId : subeventIds) {
                        Long l;
                        if (sId == null) {
                            deltime = System.currentTimeMillis() + 1000L * (long)3600 * (long)24 * (long)365 * (long)20;
                            break;
                        }
                        Long thisDeltime = this.deletionTimeForSubevent(sId, eventSlug);
                        if (thisDeltime == null) continue;
                        Long l2 = deltime;
                        if (l2 == null) {
                            l = thisDeltime;
                        } else {
                            long l3 = l2;
                            long l4 = thisDeltime;
                            l = Math.max(l3, l4);
                        }
                        deltime = l;
                    }
                }
                catch (JSONException e2) {
                    continue block2;
                }
                if (deltime == null) continue;
                o.setDeleteAfterTimestamp(deltime);
                this.store.update(o);
                if (++done % 50 != 0) continue;
                SyncManager.ProgressFeedback progressFeedback2 = this.feedback;
                if (progressFeedback2 == null) continue;
                progressFeedback2.postFeedback("Checking for old orders (" + done + '/' + ordercount + ") \u2026");
            }
            break;
        }
        SyncManager.ProgressFeedback progressFeedback3 = this.feedback;
        if (progressFeedback3 != null) {
            progressFeedback3.postFeedback("Deleting old orders\u2026");
        }
        int deleted = 0;
        while (true) {
            List ordersToDelete;
            Expression[] expressionArray = new Expression[]{Order.ID};
            WhereAndOr whereAndOr = this.store.select(expressionArray).where((Condition)Order.DELETE_AFTER_TIMESTAMP.lt((Object)System.currentTimeMillis()).and((Condition)Order.DELETE_AFTER_TIMESTAMP.gt((Object)1L)));
            Object[] e2 = new Expression[]{OrderPosition.ORDER_ID};
            Selection<Result<Tuple>> selection = this.store.select((Expression<?>[])e2);
            e2 = new Class[]{OrderPosition.class};
            WhereAndOr whereAndOr2 = selection.from((Class<?>[])e2).where((Condition)OrderPosition.SUBEVENT_ID.eq((Object)subeventId));
            Intrinsics.checkNotNullExpressionValue(whereAndOr2, "store.select(OrderPositi\u2026BEVENT_ID.eq(subeventId))");
            Intrinsics.checkNotNullExpressionValue(((Result)((WhereAndOr)whereAndOr.and((Condition)Order.ID.notIn((Return)whereAndOr2))).limit(200).get()).toList(), "store.select(Order.ID).w\u2026limit(200).get().toList()");
            if (ordersToDelete.isEmpty()) break;
            List idsToDelete = new ArrayList();
            for (Tuple t : ordersToDelete) {
                Object v = t.get(0);
                Intrinsics.checkNotNullExpressionValue(v, "t.get(0)");
                idsToDelete.add(v);
            }
            Object e3 = ((Scalar)this.store.delete(Order.class).where((Condition)Order.ID.in((Collection)idsToDelete)).get()).value();
            Intrinsics.checkNotNullExpressionValue(e3, "store.delete(Order::clas\u2026sToDelete)).get().value()");
            deleted += ((Number)e3).intValue();
            SyncManager.ProgressFeedback progressFeedback4 = this.feedback;
            if (progressFeedback4 == null) continue;
            progressFeedback4.postFeedback("Deleting old orders (" + deleted + ")\u2026");
        }
    }

    private final Long deletionTimeForEvent(String slug) {
        if (this.eventsDeletionDate.containsKey(slug)) {
            return this.eventsDeletionDate.get(slug);
        }
        Event event = (Event)((Result)this.store.select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.eq((Object)slug)).get()).firstOrNull();
        if (event == null) {
            return null;
        }
        Event e = event;
        DateTime d = new DateTime(e.getDate_to() != null ? e.getDate_to() : e.getDate_from());
        long v = d.plus(Duration.standardDays(14L)).getMillis();
        Long l = v;
        ((Map)this.eventsDeletionDate).put(slug, l);
        return v;
    }

    public final void deleteOldEvents(@NotNull List<String> keepSlugs) {
        Intrinsics.checkNotNullParameter(keepSlugs, "keepSlugs");
        if (keepSlugs.isEmpty()) {
            return;
        }
        SyncManager.ProgressFeedback progressFeedback = this.feedback;
        if (progressFeedback != null) {
            progressFeedback.postFeedback("Deleting orders of old events\u2026");
        }
        Object object = new Expression[]{Order.EVENT_SLUG};
        Selection<Result<Tuple>> selection = this.store.select((Expression<?>)object);
        object = new Class[]{Order.class};
        List list = ((Result)((Limit)((SetHavingOrderByLimit)selection.from((Class<?>)object).where((Condition)Order.EVENT_SLUG.notIn(keepSlugs)).groupBy(Order.EVENT_SLUG)).orderBy(Order.EVENT_SLUG)).get()).toList();
        Intrinsics.checkNotNullExpressionValue(list, "store.select(Order.EVENT\u2026          .get().toList()");
        List tuples = list;
        int deleted = 0;
        block0: for (Tuple t : tuples) {
            String slug = (String)t.get(0);
            Intrinsics.checkNotNullExpressionValue(slug, "slug");
            Long deletionDate = this.deletionTimeForEvent(slug);
            if (deletionDate != null && deletionDate >= System.currentTimeMillis()) continue;
            this.store.delete(ResourceSyncStatus.class).where((Condition)ResourceSyncStatus.RESOURCE.like("order%")).and((Condition)ResourceSyncStatus.EVENT_SLUG.eq((Object)slug));
            while (true) {
                List ordersToDelete;
                Expression[] expressionArray = new Expression[]{Order.ID};
                Intrinsics.checkNotNullExpressionValue(((Result)this.store.select(expressionArray).where((Condition)Order.EVENT_SLUG.eq((Object)slug)).limit(200).get()).toList(), "store.select(Order.ID).w\u2026limit(200).get().toList()");
                if (ordersToDelete.isEmpty()) continue block0;
                List idsToDelete = new ArrayList();
                for (Tuple t2 : ordersToDelete) {
                    Object v = t2.get(0);
                    Intrinsics.checkNotNullExpressionValue(v, "t2.get(0)");
                    idsToDelete.add(v);
                }
                Object e = ((Scalar)this.store.delete(Order.class).where((Condition)Order.ID.in((Collection)idsToDelete)).get()).value();
                Intrinsics.checkNotNullExpressionValue(e, "store.delete(Order::clas\u2026sToDelete)).get().value()");
                deleted += ((Number)e).intValue();
                SyncManager.ProgressFeedback progressFeedback2 = this.feedback;
                if (progressFeedback2 == null) continue;
                progressFeedback2.postFeedback("Deleting orders of old events (" + deleted + ")\u2026");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteOldPdfImages() {
        Object r = this.store.delete(CachedPdfImage.class);
        Object[] objectArray = new Expression[]{OrderPosition.SERVER_ID};
        Selection<Result<Tuple>> selection = this.store.select((Expression<?>[])objectArray);
        objectArray = new Class[]{OrderPosition.class};
        JoinWhereGroupByOrderBy joinWhereGroupByOrderBy = selection.from((Class<?>[])objectArray);
        Intrinsics.checkNotNullExpressionValue(joinWhereGroupByOrderBy, "store.select(OrderPositi\u2026rderPosition::class.java)");
        r.where((Condition)CachedPdfImage.ORDERPOSITION_ID.notIn((Return)joinWhereGroupByOrderBy));
        String[] stringArray = this.fileStorage.listFiles(OrderCleanup::deleteOldPdfImages$lambda$2);
        Intrinsics.checkNotNullExpressionValue(stringArray, "fileStorage.listFiles { \u2026startsWith(\"pdfimage_\") }");
        for (String filename : stringArray) {
            void $this$toTypedArray$iv;
            void $this$toTypedArray$iv2;
            Intrinsics.checkNotNullExpressionValue(filename, "filename");
            Object object = filename;
            Regex regex2 = new Regex("\\.");
            int n = 0;
            object = regex2.split((CharSequence)object, n);
            boolean $i$f$toTypedArray22 = false;
            Regex thisCollection$iv = $this$toTypedArray$iv2;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String namebase = stringArray2[0];
            Object $i$f$toTypedArray22 = namebase;
            thisCollection$iv = new Regex("_");
            int n2 = 0;
            $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, n2);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String etag = stringArray3[1];
            Integer n3 = (Integer)((Scalar)this.store.count(CachedPdfImage.class).where((Condition)CachedPdfImage.ETAG.eq((Object)etag)).get()).value();
            if (n3 == null || n3 != 0) continue;
            this.fileStorage.delete(filename);
        }
    }

    private static final void deletionTimeForSubevent$lambda$0(String it) {
    }

    private static final boolean deleteOldPdfImages$lambda$2(File file, String s2) {
        Intrinsics.checkNotNullExpressionValue(s2, "s");
        return StringsKt.startsWith$default(s2, "pdfimage_", false, 2, null);
    }
}

