/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import io.requery.util.CollectionObserver;
import io.requery.util.Objects;
import io.requery.util.ObservableCollection;
import io.requery.util.ObservableCollectionIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;

public class ObservableList<E>
implements List<E>,
ObservableCollection<E> {
    private final List<E> list;
    private final CollectionObserver<E> observer;

    public ObservableList(List<E> list, CollectionObserver<E> observer) {
        this.list = list;
        this.observer = observer;
    }

    @Override
    public CollectionObserver<E> observer() {
        return this.observer;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new ObservableCollectionIterator<E>(this.list, this.observer);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added = this.list.add(e);
        if (added && this.observer != null) {
            this.observer.elementAdded(e);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.list.remove(o);
        if (removed && this.observer != null) {
            Object element = o;
            this.observer.elementRemoved(element);
        }
        return removed;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        boolean modified = false;
        for (E element : c) {
            boolean added = this.add(element);
            if (modified || !added) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean modified = false;
        for (Object element : c) {
            boolean removed = this.remove(element);
            if (modified || !removed) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E element : this) {
            if (c.contains(element)) continue;
            toRemove.add(element);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public void clear() {
        if (this.observer != null) {
            for (E element : this) {
                this.observer.elementRemoved(element);
            }
        }
        this.list.clear();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        Objects.requireNotNull(element);
        E removed = this.list.set(index, element);
        if (this.observer != null) {
            if (removed != null) {
                this.observer.elementRemoved(element);
            }
            this.observer.elementAdded(element);
        }
        return removed;
    }

    @Override
    public void add(int index, E element) {
        Objects.requireNotNull(element);
        this.list.add(index, element);
        if (this.observer != null) {
            this.observer.elementAdded(element);
        }
    }

    @Override
    public E remove(int index) {
        E removed = this.list.remove(index);
        if (removed != null && this.observer != null) {
            this.observer.elementRemoved(removed);
        }
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    @Nonnull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

