/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPositionLike;
import io.requery.Column;
import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Generated;
import io.requery.Index;
import io.requery.Key;
import io.requery.ManyToOne;
import io.requery.Nullable;
import io.requery.OneToMany;
import io.requery.ReferentialAction;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractOrderPosition
implements OrderPositionLike {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    @Column(name="order_ref")
    @ForeignKey(update=ReferentialAction.CASCADE)
    @Index
    @ManyToOne
    public Order order;
    public Long positionid;
    public Long subevent_id;
    public Long variation_id;
    @Nullable
    public String attendee_name;
    @Nullable
    public String attendee_email;
    @ForeignKey(update=ReferentialAction.SET_NULL)
    @ManyToOne
    public Item item;
    @Index
    public String secret;
    @Column(definition="TEXT")
    public String json_data;
    @OneToMany
    public List<CheckIn> checkins;

    public boolean isBlocked() {
        try {
            JSONObject j = this.getJSON();
            return j.has("blocked") && !j.isNull("blocked");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public DateTime getValidFrom() {
        try {
            JSONObject j = this.getJSON();
            if (!j.has("valid_from") || j.isNull("valid_from")) {
                return null;
            }
            return ISODateTimeFormat.dateTimeParser().parseDateTime(j.getString("valid_from"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public DateTime getValidUntil() {
        try {
            JSONObject j = this.getJSON();
            if (!j.has("valid_until") || j.isNull("valid_until")) {
                return null;
            }
            return ISODateTimeFormat.dateTimeParser().parseDateTime(j.getString("valid_until"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getPrice() {
        try {
            return new BigDecimal(this.getJSON().getString("price"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getTaxRate() {
        try {
            return new BigDecimal(this.getJSON().getString("tax_rate"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getTaxValue() {
        try {
            return new BigDecimal(this.getJSON().getString("tax_value"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long getTaxRule() {
        try {
            long var = this.getJSON().optLong("tax_rule", 0L);
            if (var == 0L) {
                return null;
            }
            return var;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long getAddonToId() {
        try {
            long var = this.getJSON().optLong("addon_to", 0L);
            if (var == 0L) {
                return null;
            }
            return var;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSeatName() {
        try {
            JSONObject seat = this.getJSON().optJSONObject("seat");
            if (seat != null) {
                return seat.getString("name");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasAnyCheckins() {
        try {
            JSONArray checkins = this.getJSON().optJSONArray("checkins");
            return checkins.length() > 0;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public Map<Long, String> getAnswers() {
        try {
            JSONArray arr = this.getJSON().getJSONArray("answers");
            HashMap<Long, String> res = new HashMap<Long, String>();
            for (int i = 0; i < arr.length(); ++i) {
                res.put(arr.getJSONObject(i).getLong("question"), arr.getJSONObject(i).getString("answer"));
            }
            return res;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<Long, String> getAnswersWithOptionIds() {
        try {
            JSONArray arr = this.getJSON().getJSONArray("answers");
            HashMap<Long, String> res = new HashMap<Long, String>();
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject a = arr.getJSONObject(i);
                JSONArray opts = a.getJSONArray("options");
                if (opts.length() > 0) {
                    StringBuilder aw = new StringBuilder();
                    for (int j = 0; j < opts.length(); ++j) {
                        if (aw.length() > 0) {
                            aw.append(",");
                        }
                        aw.append(opts.getLong(j));
                    }
                    res.put(a.getLong("question"), aw.toString());
                    continue;
                }
                res.put(a.getLong("question"), a.getString("answer"));
            }
            return res;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long getSubeventId() {
        try {
            long var = this.getJSON().optLong("subevent", 0L);
            if (var == 0L) {
                return null;
            }
            return var;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long getVariationId() {
        try {
            long var = this.getJSON().optLong("variation", 0L);
            if (var == 0L) {
                return null;
            }
            return var;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public void fromJSON(JSONObject data2) throws JSONException {
        this.server_id = data2.getLong("server_id");
        this.positionid = data2.getLong("position");
        this.attendee_name = data2.getString("attendee_name");
        this.attendee_email = data2.getString("attendee_email");
        this.secret = data2.getString("secret");
        this.json_data = data2.toString();
    }

    @Override
    public String getAttendeeName() {
        return this.attendee_name;
    }

    @Override
    public String getAttendeeEmail() {
        return this.attendee_email;
    }
}

