/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy.endpoints;

import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.OnlineCheckProvider;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.pretixscan.scanproxy.ProxyDependenciesKt;
import eu.pretix.pretixscan.scanproxy.db.DownstreamDeviceEntity;
import eu.pretix.pretixscan.scanproxy.endpoints.CheckInputAnswer;
import eu.pretix.pretixscan.scanproxy.endpoints.JsonBodyHandler;
import eu.pretix.pretixscan.scanproxy.endpoints.MultiCheckInput;
import eu.pretix.pretixscan.scanproxy.endpoints.RpcKt;
import eu.pretix.pretixscan.scanproxy.endpoints.UtilsKt;
import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Leu/pretix/pretixscan/scanproxy/endpoints/MultiCheckEndpoint;", "Leu/pretix/pretixscan/scanproxy/endpoints/JsonBodyHandler;", "Leu/pretix/pretixscan/scanproxy/endpoints/MultiCheckInput;", "()V", "handle", "", "ctx", "Lio/javalin/http/Context;", "body", "server"})
public final class MultiCheckEndpoint
extends JsonBodyHandler<MultiCheckInput> {
    @NotNull
    public static final MultiCheckEndpoint INSTANCE = new MultiCheckEndpoint();

    private MultiCheckEndpoint() {
        super(MultiCheckInput.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(@NotNull Context ctx, @NotNull MultiCheckInput body2) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(body2, "body");
        Logger LOG = LoggerFactory.getLogger("eu.pretix.pretixscan.scanproxy.endpoints.MultiCheckEndpoint");
        for (String event : body2.getEvents_and_checkin_lists().keySet()) {
            UtilsKt.registerEventIfNotExists(event);
        }
        TicketCheckProvider acp = RpcKt.getCheckProvider();
        long startedAt = System.currentTimeMillis();
        try {
            Iterable<Answer> iterable;
            Iterable destination$iv$iv;
            Object object;
            String string = body2.getType();
            if (string == null) {
                string = "entry";
            }
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toUpperCase(locale)");
            TicketCheckProvider.CheckInType type2 = TicketCheckProvider.CheckInType.valueOf(string3);
            TicketCheckProvider ticketCheckProvider = acp;
            Map<String, Long> map = body2.getEvents_and_checkin_lists();
            String string4 = body2.getTicketid();
            String string5 = body2.getSource_type();
            if (string5 == null) {
                string5 = "barcode";
            }
            List<CheckInputAnswer> list = body2.getAnswers();
            if (list != null) {
                Iterable<Answer> iterable2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable3 = list;
                String string6 = string5;
                String string7 = string4;
                Map<String, Long> map2 = map;
                object = ticketCheckProvider;
                boolean $i$f$map = false;
                void var12_17 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CheckInputAnswer checkInputAnswer = (CheckInputAnswer)item$iv$iv;
                    iterable2 = destination$iv$iv;
                    boolean bl = false;
                    iterable2.add(it.toAnswer());
                }
                iterable2 = (List)destination$iv$iv;
                ticketCheckProvider = object;
                map = map2;
                string4 = string7;
                string5 = string6;
                iterable = iterable2;
            } else {
                iterable = null;
            }
            TicketCheckProvider.CheckResult result2 = TicketCheckProvider.DefaultImpls.check$default(ticketCheckProvider, map, string4, string5, iterable, body2.getIgnore_unpaid(), body2.getWith_badge_data(), type2, null, false, 384, null);
            List<TicketCheckProvider.QuestionAnswer> requiredAnswers = result2.getRequiredAnswers();
            if (requiredAnswers != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = requiredAnswers;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TicketCheckProvider.QuestionAnswer bl = (TicketCheckProvider.QuestionAnswer)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl2 = false;
                    object.add(it.getQuestion());
                }
                List questions = (List)destination$iv$iv2;
                for (Question q : questions) {
                    q.resolveDependency(questions);
                }
            }
            Object t = ctx.attribute("device");
            Intrinsics.checkNotNull(t);
            DownstreamDeviceEntity device = (DownstreamDeviceEntity)t;
            LOG.info("Scanned ticket '" + body2.getTicketid() + "' result '" + result2.getType() + "' time '" + (float)(System.currentTimeMillis() - startedAt) / 1000.0f + "s' device '" + device.getName() + "' provider '" + acp.getClass().getSimpleName() + "'");
            ctx.json(result2);
            if (acp instanceof OnlineCheckProvider) {
                if (result2.getType() == TicketCheckProvider.CheckResult.Type.ERROR) {
                    ProxyDependenciesKt.getProxyDeps().getConnectivityHelper().recordError();
                } else {
                    ProxyDependenciesKt.getProxyDeps().getConnectivityHelper().recordSuccess(System.currentTimeMillis() - startedAt);
                }
            }
        }
        catch (CheckException e) {
            ProxyDependenciesKt.getProxyDeps().getConnectivityHelper().recordError();
            ctx.status(400).json(MapsKt.mapOf(TuplesKt.to("title", e.getMessage())));
        }
    }
}

