/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.RemoteObject;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Index;
import io.requery.Key;
import io.requery.OneToMany;
import io.requery.Table;
import java.math.BigDecimal;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Table(name="orders")
@Entity(cacheable=false)
public class AbstractOrder
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    @Index
    public String event_slug;
    @Index
    public String code;
    public String status;
    public String email;
    public Long deleteAfterTimestamp;
    public boolean checkin_attention;
    @Column(definition="TEXT")
    public String checkin_text;
    @Column(value="false")
    public boolean valid_if_pending;
    @Column(definition="TEXT")
    public String json_data;
    @OneToMany
    public List<OrderPosition> positions;

    public boolean isTestmode() {
        try {
            return this.getJSON().getBoolean("testmode");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isRequireApproval() {
        try {
            return this.getJSON().getBoolean("require_approval");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isValidStatus() {
        if ("p".equals(this.status)) {
            return true;
        }
        if ("n".equals(this.status)) {
            return this.valid_if_pending;
        }
        return false;
    }

    public String getPaymentProvider() {
        try {
            return this.getJSON().getString("payment_provider");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getTotal() {
        try {
            return new BigDecimal(this.getJSON().getString("total"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BigDecimal getPendingTotal() {
        try {
            JSONObject j = this.getJSON();
            BigDecimal total = new BigDecimal(j.getString("total"));
            if (j.getString("status").equals("c")) {
                total = BigDecimal.ZERO;
            }
            BigDecimal paymentSum = BigDecimal.ZERO;
            JSONArray payments = j.getJSONArray("payments");
            for (int i = 0; i < payments.length(); ++i) {
                JSONObject payment = payments.getJSONObject(i);
                if (!payment.getString("state").matches("^(confirmed|refunded)$")) continue;
                paymentSum = paymentSum.add(new BigDecimal(payment.getString("amount")));
            }
            BigDecimal refundSum = BigDecimal.ZERO;
            JSONArray refunds = j.getJSONArray("refunds");
            for (int i = 0; i < refunds.length(); ++i) {
                JSONObject refund = refunds.getJSONObject(i);
                if (!refund.getString("state").matches("^(done|transit|created)$")) continue;
                refundSum = refundSum.add(new BigDecimal(refund.getString("amount")));
            }
            return total.subtract(paymentSum).add(refundSum);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }
}

