/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.pretixscan.scanproxy;

import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.pretixscan.scanproxy.ConnectivityChangedListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Leu/pretix/pretixscan/scanproxy/ConnectivityHelper;", "Leu/pretix/libpretixsync/sync/SyncManager$CheckConnectivityFeedback;", "autoOfflineMode", "", "(Ljava/lang/String;)V", "HISTORY_SIZE", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_ERRORS_IN_HISTORY", "getAutoOfflineMode", "()Ljava/lang/String;", "hardOffline", "", "isOffline", "()Z", "setOffline", "(Z)V", "listeners", "", "Leu/pretix/pretixscan/scanproxy/ConnectivityChangedListener;", "resultHistory", "", "addListener", "", "listener", "checkConditions", "ensureHistorySize", "recordError", "recordSuccess", "durationInMillis", "removeListener", "resetHistory", "setHardOffline", "server"})
public final class ConnectivityHelper
implements SyncManager.CheckConnectivityFeedback {
    @NotNull
    private final String autoOfflineMode;
    @NotNull
    private final List<Long> resultHistory;
    private final int HISTORY_SIZE;
    private final int MAX_ERRORS_IN_HISTORY;
    @NotNull
    private final List<ConnectivityChangedListener> listeners;
    private boolean hardOffline;
    private final Logger LOG;
    private boolean isOffline;

    public ConnectivityHelper(@NotNull String autoOfflineMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter(autoOfflineMode, "autoOfflineMode");
        this.autoOfflineMode = autoOfflineMode;
        this.resultHistory = new ArrayList();
        this.HISTORY_SIZE = 5;
        this.MAX_ERRORS_IN_HISTORY = 2;
        this.listeners = new ArrayList();
        this.LOG = LoggerFactory.getLogger("eu.pretix.pretixscan.scanproxy.ConnectivtyHelper");
        switch (this.autoOfflineMode) {
            case "off": {
                bl = true;
                break;
            }
            case "3s": 
            case "2s": 
            case "1s": 
            case "10s": 
            case "20s": 
            case "5s": 
            case "errors": 
            case "15s": 
            case "on": {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        this.isOffline = bl;
        if (this.isOffline) {
            this.LOG.info("Starting in offline mode");
        } else {
            this.LOG.info("Starting in online mode");
        }
    }

    @NotNull
    public final String getAutoOfflineMode() {
        return this.autoOfflineMode;
    }

    public final boolean isOffline() {
        return this.isOffline;
    }

    public final void setOffline(boolean bl) {
        this.isOffline = bl;
    }

    private final void ensureHistorySize() {
        while (this.resultHistory.size() > this.HISTORY_SIZE) {
            this.resultHistory.remove(0);
        }
    }

    public final void resetHistory() {
        this.resultHistory.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkConditions() {
        int n;
        switch (this.autoOfflineMode) {
            case "off": {
                return;
            }
            case "1s": {
                n = 1000;
                break;
            }
            case "2s": {
                n = 2000;
                break;
            }
            case "3s": {
                n = 3000;
                break;
            }
            case "5s": {
                n = 5000;
                break;
            }
            case "10s": {
                n = 10000;
                break;
            }
            case "15s": {
                n = 15000;
                break;
            }
            case "20s": {
                n = 20000;
                break;
            }
            case "errors": {
                n = 3600000;
                break;
            }
            case "on": {
                n = 3600000;
                break;
            }
            default: {
                return;
            }
        }
        int maxDuration = n;
        if (this.isOffline) {
            if (this.hardOffline) return;
            if (this.resultHistory.size() != 0) {
                int n2;
                Iterable $this$count$iv = this.resultHistory;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        Long it = (Long)element$iv;
                        boolean bl = false;
                        if (!(it == null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                if (n2 != 0) return;
                if (this.resultHistory.size() < this.MAX_ERRORS_IN_HISTORY) return;
                if (!(ArraysKt.average(CollectionsKt.toLongArray(CollectionsKt.filterNotNull((Iterable)this.resultHistory))) < (double)maxDuration)) return;
            }
            boolean bl = true;
            boolean switchToOnline = bl;
            if (!switchToOnline) return;
            this.LOG.info("Switching to online mode (history: " + this.resultHistory + ")");
            this.isOffline = false;
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            Iterator count$iv = $this$forEach$iv.iterator();
            while (count$iv.hasNext()) {
                Object t = count$iv.next();
                ConnectivityChangedListener it = (ConnectivityChangedListener)t;
                boolean bl2 = false;
                it.onConnectivityChanged(this.isOffline);
            }
            return;
        }
        if (!this.hardOffline) {
            int n3;
            Iterable $this$count$iv = this.resultHistory;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Long it = (Long)element$iv;
                    boolean bl = false;
                    if (!(it == null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            if (n3 < this.MAX_ERRORS_IN_HISTORY) {
                if (this.resultHistory.size() < this.MAX_ERRORS_IN_HISTORY) return;
                if (!(ArraysKt.average(CollectionsKt.toLongArray(CollectionsKt.filterNotNull((Iterable)this.resultHistory))) >= (double)maxDuration)) return;
            }
        }
        boolean bl = true;
        boolean switchToOffline = bl;
        if (!switchToOffline) return;
        this.LOG.info("Switching to offline mode (history: " + this.resultHistory + ")");
        this.isOffline = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            ConnectivityChangedListener it = (ConnectivityChangedListener)t;
            boolean bl3 = false;
            it.onConnectivityChanged(this.isOffline);
        }
    }

    public void recordSuccess(long durationInMillis) {
        this.resultHistory.add(durationInMillis);
        this.ensureHistorySize();
        this.checkConditions();
    }

    @Override
    public void recordError() {
        this.resultHistory.add(null);
        this.ensureHistorySize();
        this.checkConditions();
    }

    public final void setHardOffline(boolean hardOffline) {
        this.hardOffline = hardOffline;
        this.checkConditions();
    }

    public final void addListener(@NotNull ConnectivityChangedListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.add(listener);
    }

    public final void removeListener(@NotNull ConnectivityChangedListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.listeners.remove(listener);
    }
}

