/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java8.util.Objects;
import java8.util.Optional;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.function.BiConsumer;
import java8.util.function.BiFunction;
import java8.util.function.BinaryOperator;
import java8.util.function.BinaryOperators;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.Function;
import java8.util.function.IntConsumer;
import java8.util.function.IntFunction;
import java8.util.function.LongConsumer;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.function.ToDoubleFunction;
import java8.util.function.ToIntFunction;
import java8.util.function.ToLongFunction;
import java8.util.stream.AbstractPipeline;
import java8.util.stream.BaseStream;
import java8.util.stream.Collector;
import java8.util.stream.Collectors;
import java8.util.stream.DistinctOps;
import java8.util.stream.DoublePipeline;
import java8.util.stream.DoubleStream;
import java8.util.stream.FindOps;
import java8.util.stream.ForEachOps;
import java8.util.stream.IntPipeline;
import java8.util.stream.IntStream;
import java8.util.stream.LongPipeline;
import java8.util.stream.LongStream;
import java8.util.stream.MatchOps;
import java8.util.stream.Node;
import java8.util.stream.Nodes;
import java8.util.stream.PipelineHelper;
import java8.util.stream.ReduceOps;
import java8.util.stream.ReferencePipeline$$Lambda$1;
import java8.util.stream.ReferencePipeline$$Lambda$2;
import java8.util.stream.ReferencePipeline$10$1$$Lambda$1;
import java8.util.stream.ReferencePipeline$8$1$$Lambda$1;
import java8.util.stream.ReferencePipeline$9$1$$Lambda$1;
import java8.util.stream.Sink;
import java8.util.stream.SliceOps;
import java8.util.stream.SortedOps;
import java8.util.stream.Stream;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.WhileOps;

abstract class ReferencePipeline<P_IN, P_OUT>
extends AbstractPipeline<P_IN, P_OUT, Stream<P_OUT>>
implements Stream<P_OUT> {
    ReferencePipeline(Supplier<? extends Spliterator<?>> source2, int sourceFlags, boolean parallel) {
        super(source2, sourceFlags, parallel);
    }

    ReferencePipeline(Spliterator<?> source2, int sourceFlags, boolean parallel) {
        super(source2, sourceFlags, parallel);
    }

    ReferencePipeline(AbstractPipeline<?, P_IN, ?> upstream, int opFlags) {
        super(upstream, opFlags);
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.REFERENCE;
    }

    @Override
    final <P_IN_> Node<P_OUT> evaluateToNode(PipelineHelper<P_OUT> helper, Spliterator<P_IN_> spliterator, boolean flattenTree, IntFunction<P_OUT[]> generator) {
        return Nodes.collect(helper, spliterator, flattenTree, generator);
    }

    @Override
    final <P_IN_> Spliterator<P_OUT> wrap(PipelineHelper<P_OUT> ph, Supplier<Spliterator<P_IN_>> supplier, boolean isParallel) {
        return new StreamSpliterators.WrappingSpliterator(ph, supplier, isParallel);
    }

    @Override
    final Spliterator<P_OUT> lazySpliterator(Supplier<? extends Spliterator<P_OUT>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator(supplier);
    }

    @Override
    final boolean forEachWithCancel(Spliterator<P_OUT> spliterator, Sink<P_OUT> sink2) {
        boolean cancelled;
        while (!(cancelled = sink2.cancellationRequested()) && spliterator.tryAdvance(sink2)) {
        }
        return cancelled;
    }

    @Override
    final Node.Builder<P_OUT> makeNodeBuilder(long exactSizeIfKnown, IntFunction<P_OUT[]> generator) {
        return Nodes.builder(exactSizeIfKnown, generator);
    }

    @Override
    public final Iterator<P_OUT> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Stream<P_OUT> unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink2) {
                return sink2;
            }
        };
    }

    @Override
    public final Stream<P_OUT> filter(final Predicate<? super P_OUT> predicate) {
        Objects.requireNonNull(predicate);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink2) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        if (predicate.test(u)) {
                            this.downstream.accept(u);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> map(final Function<? super P_OUT, ? extends R> mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink2) {
                return new Sink.ChainedReference<P_OUT, R>(sink2){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper2.apply(u));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapToInt(final ToIntFunction<? super P_OUT> mapper2) {
        Objects.requireNonNull(mapper2);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink2){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper2.applyAsInt(u));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapToLong(final ToLongFunction<? super P_OUT> mapper2) {
        Objects.requireNonNull(mapper2);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink2) {
                return new Sink.ChainedReference<P_OUT, Long>(sink2){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper2.applyAsLong(u));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final ToDoubleFunction<? super P_OUT> mapper2) {
        Objects.requireNonNull(mapper2);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink2) {
                return new Sink.ChainedReference<P_OUT, Double>(sink2){

                    @Override
                    public void accept(P_OUT u) {
                        this.downstream.accept(mapper2.applyAsDouble(u));
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> flatMap(final Function<? super P_OUT, ? extends Stream<? extends R>> mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink2) {
                return new Sink.ChainedReference<P_OUT, R>(sink2){
                    boolean cancellationRequested;

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(P_OUT u) {
                        BaseStream result2 = null;
                        try {
                            result2 = (Stream)mapper2.apply(u);
                            if (result2 != null) {
                                if (!this.cancellationRequested) {
                                    ((Stream)result2.sequential()).forEach(this.downstream);
                                } else {
                                    Spliterator s2 = ((Stream)result2.sequential()).spliterator();
                                    while (!this.downstream.cancellationRequested() && s2.tryAdvance(this.downstream)) {
                                    }
                                }
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final IntStream flatMapToInt(final Function<? super P_OUT, ? extends IntStream> mapper2) {
        Objects.requireNonNull(mapper2);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink2){
                    boolean cancellationRequested;
                    IntConsumer downstreamAsInt;
                    {
                        Sink sink2 = this.downstream;
                        sink2.getClass();
                        this.downstreamAsInt = ReferencePipeline$8$1$$Lambda$1.lambdaFactory$(sink2);
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(P_OUT u) {
                        BaseStream result2 = null;
                        try {
                            result2 = (IntStream)mapper2.apply(u);
                            if (result2 != null) {
                                if (!this.cancellationRequested) {
                                    result2.sequential().forEach(this.downstreamAsInt);
                                } else {
                                    Spliterator.OfInt s2 = result2.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s2.tryAdvance(this.downstreamAsInt)) {
                                    }
                                }
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream flatMapToDouble(final Function<? super P_OUT, ? extends DoubleStream> mapper2) {
        Objects.requireNonNull(mapper2);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink2) {
                return new Sink.ChainedReference<P_OUT, Double>(sink2){
                    boolean cancellationRequested;
                    DoubleConsumer downstreamAsDouble;
                    {
                        Sink sink2 = this.downstream;
                        sink2.getClass();
                        this.downstreamAsDouble = ReferencePipeline$9$1$$Lambda$1.lambdaFactory$(sink2);
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(P_OUT u) {
                        BaseStream result2 = null;
                        try {
                            result2 = (DoubleStream)mapper2.apply(u);
                            if (result2 != null) {
                                if (!this.cancellationRequested) {
                                    result2.sequential().forEach(this.downstreamAsDouble);
                                } else {
                                    Spliterator.OfDouble s2 = result2.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s2.tryAdvance(this.downstreamAsDouble)) {
                                    }
                                }
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final LongStream flatMapToLong(final Function<? super P_OUT, ? extends LongStream> mapper2) {
        Objects.requireNonNull(mapper2);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink2) {
                return new Sink.ChainedReference<P_OUT, Long>(sink2){
                    boolean cancellationRequested;
                    LongConsumer downstreamAsLong;
                    {
                        Sink sink2 = this.downstream;
                        sink2.getClass();
                        this.downstreamAsLong = ReferencePipeline$10$1$$Lambda$1.lambdaFactory$(sink2);
                    }

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(P_OUT u) {
                        BaseStream result2 = null;
                        try {
                            result2 = (LongStream)mapper2.apply(u);
                            if (result2 != null) {
                                if (!this.cancellationRequested) {
                                    result2.sequential().forEach(this.downstreamAsLong);
                                } else {
                                    Spliterator.OfLong s2 = result2.sequential().spliterator();
                                    while (!this.downstream.cancellationRequested() && s2.tryAdvance(this.downstreamAsLong)) {
                                    }
                                }
                            }
                        }
                        finally {
                            if (result2 != null) {
                                result2.close();
                            }
                        }
                    }

                    @Override
                    public boolean cancellationRequested() {
                        this.cancellationRequested = true;
                        return this.downstream.cancellationRequested();
                    }
                };
            }
        };
    }

    @Override
    public final <R> Stream<R> mapMulti(final BiConsumer<? super P_OUT, ? super Consumer<R>> mapper2) {
        Objects.requireNonNull(mapper2);
        return new StatelessOp<P_OUT, R>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<R> sink2) {
                return new Sink.ChainedReference<P_OUT, R>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper2.accept(u, this.downstream);
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapMultiToInt(final BiConsumer<? super P_OUT, ? super IntConsumer> mapper2) {
        Objects.requireNonNull(mapper2);
        return new IntPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Integer> sink2) {
                return new Sink.ChainedReference<P_OUT, Integer>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper2.accept(u, (IntConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream mapMultiToLong(final BiConsumer<? super P_OUT, ? super LongConsumer> mapper2) {
        Objects.requireNonNull(mapper2);
        return new LongPipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Long> sink2) {
                return new Sink.ChainedReference<P_OUT, Long>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper2.accept(u, (LongConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapMultiToDouble(final BiConsumer<? super P_OUT, ? super DoubleConsumer> mapper2) {
        Objects.requireNonNull(mapper2);
        return new DoublePipeline.StatelessOp<P_OUT>(this, StreamShape.REFERENCE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<Double> sink2) {
                return new Sink.ChainedReference<P_OUT, Double>(sink2){

                    @Override
                    public void begin(long size) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(P_OUT u) {
                        mapper2.accept(u, (DoubleConsumer)((Object)this.downstream));
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> peek(final Consumer<? super P_OUT> action) {
        Objects.requireNonNull(action);
        return new StatelessOp<P_OUT, P_OUT>(this, StreamShape.REFERENCE, 0){

            @Override
            Sink<P_OUT> opWrapSink(int flags, Sink<P_OUT> sink2) {
                return new Sink.ChainedReference<P_OUT, P_OUT>(sink2){

                    @Override
                    public void accept(P_OUT u) {
                        action.accept(u);
                        this.downstream.accept(u);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<P_OUT> distinct() {
        return DistinctOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted() {
        return SortedOps.makeRef(this);
    }

    @Override
    public final Stream<P_OUT> sorted(Comparator<? super P_OUT> comparator) {
        return SortedOps.makeRef(this, comparator);
    }

    @Override
    public final Stream<P_OUT> limit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        return SliceOps.makeRef(this, 0L, maxSize);
    }

    @Override
    public final Stream<P_OUT> skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        if (n == 0L) {
            return this;
        }
        return SliceOps.makeRef(this, n, -1L);
    }

    @Override
    public final Stream<P_OUT> takeWhile(Predicate<? super P_OUT> predicate) {
        return WhileOps.makeTakeWhileRef(this, predicate);
    }

    @Override
    public final Stream<P_OUT> dropWhile(Predicate<? super P_OUT> predicate) {
        return WhileOps.makeDropWhileRef(this, predicate);
    }

    @Override
    public void forEach(Consumer<? super P_OUT> action) {
        this.evaluate(ForEachOps.makeRef(action, false));
    }

    @Override
    public void forEachOrdered(Consumer<? super P_OUT> action) {
        this.evaluate(ForEachOps.makeRef(action, true));
    }

    @Override
    public final <A> A[] toArray(IntFunction<A[]> generator) {
        IntFunction<T[]> rawGenerator = generator;
        return Nodes.flatten(this.evaluateToArrayNode(rawGenerator), generator).asArray(rawGenerator);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(ReferencePipeline$$Lambda$1.lambdaFactory$());
    }

    @Override
    public List<P_OUT> toList() {
        return Collectors.listFromTrustedArrayNullsAllowed(this.toArray());
    }

    @Override
    public final boolean anyMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(Predicate<? super P_OUT> predicate) {
        return this.evaluate(MatchOps.makeRef(predicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final Optional<P_OUT> findFirst() {
        return this.evaluate(FindOps.makeRef(true));
    }

    @Override
    public final Optional<P_OUT> findAny() {
        return this.evaluate(FindOps.makeRef(false));
    }

    @Override
    public final P_OUT reduce(P_OUT identity, BinaryOperator<P_OUT> accumulator) {
        return this.evaluate(ReduceOps.makeRef(identity, accumulator, accumulator));
    }

    @Override
    public final Optional<P_OUT> reduce(BinaryOperator<P_OUT> accumulator) {
        return this.evaluate(ReduceOps.makeRef(accumulator));
    }

    @Override
    public final <R> R reduce(R identity, BiFunction<R, ? super P_OUT, R> accumulator, BinaryOperator<R> combiner) {
        return this.evaluate(ReduceOps.makeRef(identity, accumulator, combiner));
    }

    @Override
    public final <R, A> R collect(Collector<? super P_OUT, A, R> collector) {
        A container;
        if (this.isParallel() && collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT) && (!this.isOrdered() || collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED))) {
            container = collector.supplier().get();
            BiConsumer<A, ? super P_OUT> accumulator = collector.accumulator();
            this.forEach(ReferencePipeline$$Lambda$2.lambdaFactory$(accumulator, container));
        } else {
            container = this.evaluate(ReduceOps.makeRef(collector));
        }
        return (R)(collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? container : collector.finisher().apply(container));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super P_OUT> accumulator, BiConsumer<R, R> combiner) {
        return this.evaluate(ReduceOps.makeRef(supplier, accumulator, combiner));
    }

    @Override
    public final Optional<P_OUT> max(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperators.maxBy(comparator));
    }

    @Override
    public final Optional<P_OUT> min(Comparator<? super P_OUT> comparator) {
        return this.reduce((BinaryOperator<P_OUT>)BinaryOperators.minBy(comparator));
    }

    @Override
    public final long count() {
        return this.evaluate(ReduceOps.makeRefCounting());
    }

    static /* synthetic */ void lambda$collect$100(BiConsumer biConsumer, Object object, Object u) {
        biConsumer.accept(object, u);
    }

    static /* synthetic */ Object[] lambda$toArray$99(int x$0) {
        return new Object[x$0];
    }

    static abstract class StatefulOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<E_OUT> opEvaluateParallel(PipelineHelper<E_OUT> var1, Spliterator<P_IN> var2, IntFunction<E_OUT[]> var3);
    }

    static abstract class StatelessOp<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> upstream, StreamShape inputShape, int opFlags) {
            super(upstream, opFlags);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN, E_OUT>
    extends ReferencePipeline<E_IN, E_OUT> {
        Head(Supplier<? extends Spliterator<?>> source2, int sourceFlags, boolean parallel) {
            super(source2, sourceFlags, parallel);
        }

        Head(Spliterator<?> source2, int sourceFlags, boolean parallel) {
            super(source2, sourceFlags, parallel);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int flags, Sink<E_OUT> sink2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E_OUT> action) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(action);
            } else {
                super.forEach(action);
            }
        }

        @Override
        public void forEachOrdered(Consumer<? super E_OUT> action) {
            if (!this.isParallel()) {
                this.sourceStageSpliterator().forEachRemaining(action);
            } else {
                super.forEachOrdered(action);
            }
        }
    }
}

