/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.serialization.JSONArrayDeserializer;
import eu.pretix.libpretixsync.serialization.JSONArraySerializer;
import eu.pretix.libpretixsync.serialization.JSONObjectDeserializer;
import eu.pretix.libpretixsync.serialization.JSONObjectSerializer;
import eu.pretix.libpretixsync.utils.NetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0011H\u0016Jf\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00162\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Leu/pretix/libpretixsync/check/ProxyCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "(Leu/pretix/libpretixsync/config/ConfigStore;Leu/pretix/libpretixsync/api/HttpClientFactory;)V", "client", "Lokhttp3/OkHttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "eventsAndCheckinLists", "", "", "", "ticketid", "source_type", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "nonce", "allowQuestions", "execute", "r", "Lokhttp3/Request;", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "", "setSentry", "", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "eventSlug", "listId", "libpretixsync"})
public final class ProxyCheckProvider
implements TicketCheckProvider {
    @NotNull
    private final ConfigStore config;
    @NotNull
    private SentryInterface sentry;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final ObjectMapper mapper;

    public ProxyCheckProvider(@NotNull ConfigStore config, @NotNull HttpClientFactory httpClientFactory2) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(httpClientFactory2, "httpClientFactory");
        this.config = config;
        this.sentry = new DummySentryImplementation();
        OkHttpClient okHttpClient = httpClientFactory2.buildClient(NetUtils.ignoreSSLforURL(this.config.getApiUrl()));
        Intrinsics.checkNotNullExpressionValue(okHttpClient, "httpClientFactory.buildC\u2026SSLforURL(config.apiUrl))");
        this.client = okHttpClient;
        this.mapper = new ObjectMapper();
        SimpleModule m3 = new SimpleModule();
        m3.addDeserializer(JSONObject.class, new JSONObjectDeserializer(null, 1, null));
        m3.addDeserializer(JSONArray.class, new JSONArrayDeserializer(null, 1, null));
        m3.addSerializer(JSONObject.class, new JSONObjectSerializer(null, 1, null));
        m3.addSerializer(JSONArray.class, new JSONArraySerializer(null, 1, null));
        this.mapper.registerModule(m3);
        this.mapper.registerModule(new KotlinModule(0, false, false, false, null, false, 63, null));
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
    }

    private final String execute(Request r) throws ApiException, CheckException {
        String e3;
        Response response;
        Response response2 = null;
        try {
            response = this.client.newCall(r).execute();
        }
        catch (SSLException e2) {
            e2.printStackTrace();
            throw new ApiException("Error while creating a secure connection.", e2);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            throw new ApiException("Connection error: " + e3.getMessage(), e3);
        }
        response2 = response;
        this.sentry.addHttpBreadcrumb(r.url().toString(), r.method(), response2.code());
        String body2 = "";
        try {
            ResponseBody responseBody = response2.body();
            Intrinsics.checkNotNull(responseBody);
            e3 = responseBody.string();
        }
        catch (IOException e4) {
            e4.printStackTrace();
            throw new ApiException("Connection error: " + e4.getMessage(), e4);
        }
        body2 = e3;
        if (response2.code() >= 500) {
            response2.close();
            throw new ApiException("Server error: " + response2.code());
        }
        if (response2.code() == 404) {
            response2.close();
            throw new ApiException("Server error: Resource not found.");
        }
        if (response2.code() == 403) {
            response2.close();
            throw new ApiException("Server error: Permission denied.");
        }
        if (response2.code() >= 400) {
            response2.close();
            try {
                throw new CheckException(new JSONObject("body").optString("title", "?"), null, 2, null);
            }
            catch (JSONException e5) {
                throw new ApiException(body2);
            }
        }
        if (response2.code() >= 405) {
            response2.close();
            throw new ApiException("Server error: " + response2.code() + '.');
        }
        return body2;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid, @NotNull String source_type, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type2, @Nullable String nonce, boolean allowQuestions) {
        TicketCheckProvider.CheckResult checkResult;
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        Intrinsics.checkNotNullParameter(source_type, "source_type");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Map data2 = new HashMap();
        data2.put("events_and_checkin_lists", eventsAndCheckinLists);
        data2.put("ticketid", ticketid);
        List<Answer> list = answers;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        data2.put("answers", list);
        Boolean bl = ignore_unpaid;
        data2.put("ignore_unpaid", bl);
        bl = with_badge_data;
        data2.put("with_badge_data", bl);
        data2.put("source_type", source_type);
        data2.put("type", type2);
        bl = allowQuestions;
        data2.put("allowQuestions", bl);
        if (nonce != null) {
            data2.put("nonce", nonce);
        }
        try {
            Request.Builder builder = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/check/");
            String string = this.mapper.writeValueAsString(data2);
            Intrinsics.checkNotNullExpressionValue(string, "mapper.writeValueAsString(data)");
            Request request = builder.post(RequestBody.Companion.create(string, MediaType.Companion.get("application/json"))).header("Authorization", "Device " + this.config.getApiKey()).build();
            String body2 = this.execute(request);
            checkResult = this.mapper.readValue(body2, TicketCheckProvider.CheckResult.class);
            Intrinsics.checkNotNullExpressionValue(checkResult, "{\n            val reques\u2026lt::class.java)\n        }");
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", "API Error: " + e.getMessage());
            checkResult = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage(), false, 4, null);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            checkResult = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage(), false, 4, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            checkResult = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage(), false, 4, null);
        }
        catch (CheckException e) {
            checkResult = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage(), false, 4, null);
        }
        return checkResult;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return TicketCheckProvider.DefaultImpls.check$default(this, eventsAndCheckinLists, ticketid, "barcode", new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY, null, false, 384, null);
    }

    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String query, int page) throws CheckException {
        List list;
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(query, "query");
        Map data2 = new HashMap();
        data2.put("events_and_checkin_lists", eventsAndCheckinLists);
        data2.put("query", query);
        Integer n = page;
        data2.put("page", n);
        try {
            Request.Builder builder = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/search/");
            String string = this.mapper.writeValueAsString(data2);
            Intrinsics.checkNotNullExpressionValue(string, "mapper.writeValueAsString(data)");
            Request request = builder.post(RequestBody.Companion.create(string, MediaType.Companion.get("application/json"))).header("Authorization", "Device " + this.config.getApiKey()).build();
            String body2 = this.execute(request);
            ObjectMapper $this$readValue$iv = this.mapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            list = (List)$this$readValue$iv.readValue(body2, (TypeReference)new TypeReference<List<? extends TicketCheckProvider.SearchResult>>(){});
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", "API Error: " + e.getMessage());
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    @Nullable
    public TicketCheckProvider.StatusResult status(@NotNull String eventSlug, long listId) throws CheckException {
        TicketCheckProvider.StatusResult statusResult;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        Request request = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/" + eventSlug + '/' + listId + "/status/").header("Authorization", "Device " + this.config.getApiKey()).build();
        try {
            String body2 = this.execute(request);
            statusResult = this.mapper.readValue(body2, TicketCheckProvider.StatusResult.class);
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.status", "API Error: " + e.getMessage());
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        return statusResult;
    }
}

