/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.proxy.EntityProxy;
import io.requery.proxy.EntityStateEventListeners;
import io.requery.proxy.PostDeleteListener;
import io.requery.proxy.PostInsertListener;
import io.requery.proxy.PostLoadListener;
import io.requery.proxy.PostUpdateListener;
import io.requery.proxy.PreDeleteListener;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.PreUpdateListener;

class CompositeEntityListener<T>
extends EntityStateEventListeners<T> {
    private boolean enableStateListeners;

    CompositeEntityListener() {
    }

    void enableStateListeners(boolean enabled) {
        this.enableStateListeners = enabled;
    }

    void preUpdate(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PreUpdateListener listener : this.preUpdateListeners) {
                listener.preUpdate(entity);
            }
        }
        if (proxy != null) {
            proxy.preUpdate();
        }
    }

    void postUpdate(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PostUpdateListener listener : this.postUpdateListeners) {
                listener.postUpdate(entity);
            }
        }
        if (proxy != null) {
            proxy.postUpdate();
        }
    }

    void preInsert(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PreInsertListener listener : this.preInsertListeners) {
                listener.preInsert(entity);
            }
        }
        if (proxy != null) {
            proxy.preInsert();
        }
    }

    void postInsert(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PostInsertListener listener : this.postInsertListeners) {
                listener.postInsert(entity);
            }
        }
        if (proxy != null) {
            proxy.postInsert();
        }
    }

    void preDelete(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PreDeleteListener listener : this.preDeleteListeners) {
                listener.preDelete(entity);
            }
        }
        if (proxy != null) {
            proxy.preDelete();
        }
    }

    void postDelete(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PostDeleteListener listener : this.postDeleteListeners) {
                listener.postDelete(entity);
            }
        }
        if (proxy != null) {
            proxy.postDelete();
        }
    }

    void postLoad(T entity, EntityProxy<? extends T> proxy) {
        if (this.enableStateListeners) {
            for (PostLoadListener listener : this.postLoadListeners) {
                listener.postLoad(entity);
            }
        }
        if (proxy != null) {
            proxy.postLoad();
        }
    }
}

