/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.Expression;
import io.requery.query.element.GroupByElement;
import io.requery.query.element.HavingConditionElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import java.util.Set;

class GroupByGenerator
implements Generator<GroupByElement> {
    GroupByGenerator() {
    }

    @Override
    public void write(final Output output, GroupByElement query) {
        QueryBuilder qb = output.builder();
        Set<Expression<?>> groupBy = query.getGroupByExpressions();
        if (groupBy != null && groupBy.size() > 0) {
            qb.keyword(Keyword.GROUP, Keyword.BY);
            qb.commaSeparated(groupBy, new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    output.appendColumn(value);
                }
            });
            if (query.getHavingElements() != null) {
                qb.keyword(Keyword.HAVING);
                for (HavingConditionElement<?> clause : query.getHavingElements()) {
                    output.appendConditional(clause);
                }
            }
        }
    }
}

