/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class ArrayDequeSpliterator<E>
implements Spliterator<E> {
    private final ArrayDeque<E> deq;
    private int fence;
    private int index;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long TAIL_OFF;
    private static final long HEAD_OFF;
    private static final long DATA_OFF;

    private ArrayDequeSpliterator(ArrayDeque<E> deq, int origin, int fence) {
        this.deq = deq;
        this.index = origin;
        this.fence = fence;
    }

    static <T> Spliterator<T> spliterator(ArrayDeque<T> deque) {
        return new ArrayDequeSpliterator<T>(deque, -1, -1);
    }

    private int getFence() {
        int t = this.fence;
        if (t < 0) {
            t = this.fence = ArrayDequeSpliterator.getTail(this.deq);
            this.index = ArrayDequeSpliterator.getHead(this.deq);
        }
        return t;
    }

    @Override
    public ArrayDequeSpliterator<E> trySplit() {
        int t = this.getFence();
        int h2 = this.index;
        int n = ArrayDequeSpliterator.getData(this.deq).length;
        if (h2 != t && (h2 + 1 & n - 1) != t) {
            int m3;
            if (h2 > t) {
                t += n;
            }
            this.index = m3 = h2 + t >>> 1 & n - 1;
            return new ArrayDequeSpliterator<E>(this.deq, h2, this.index);
        }
        return null;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Object[] a = ArrayDequeSpliterator.getData(this.deq);
        int m3 = a.length - 1;
        int f = this.getFence();
        int i = this.index;
        this.index = f;
        while (i != f) {
            Object e = a[i];
            i = i + 1 & m3;
            if (e == null) {
                throw new ConcurrentModificationException();
            }
            action.accept(e);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Object[] a = ArrayDequeSpliterator.getData(this.deq);
        int m3 = a.length - 1;
        int f = this.getFence();
        int i = this.index;
        if (i != this.fence) {
            Object e = a[i];
            this.index = i + 1 & m3;
            if (e == null) {
                throw new ConcurrentModificationException();
            }
            action.accept(e);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        int n = this.getFence() - this.index;
        if (n < 0) {
            n += ArrayDequeSpliterator.getData(this.deq).length;
        }
        return n;
    }

    @Override
    public int characteristics() {
        return 16720;
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    private static <T> int getTail(ArrayDeque<T> deq) {
        return U.getInt(deq, TAIL_OFF);
    }

    private static <T> int getHead(ArrayDeque<T> deq) {
        return U.getInt(deq, HEAD_OFF);
    }

    private static <T> Object[] getData(ArrayDeque<T> deq) {
        return (Object[])U.getObject(deq, DATA_OFF);
    }

    static {
        try {
            TAIL_OFF = U.objectFieldOffset(ArrayDeque.class.getDeclaredField("tail"));
            HEAD_OFF = U.objectFieldOffset(ArrayDeque.class.getDeclaredField("head"));
            DATA_OFF = U.objectFieldOffset(ArrayDeque.class.getDeclaredField("elements"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

