/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.query.function.Function;
import io.requery.query.function.Now;
import io.requery.sql.AutoIncrementColumnDefinition;
import io.requery.sql.BasicType;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.LimitGenerator;
import io.requery.sql.gen.Output;
import io.requery.sql.platform.Generic;
import io.requery.sql.type.PrimitiveLongType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class SQLite
extends Generic {
    private final AutoIncrementColumnDefinition autoIncrementColumn = new AutoIncrementColumnDefinition("autoincrement");

    @Override
    public void addMappings(Mapping mapping) {
        super.addMappings(mapping);
        mapping.putType(Long.TYPE, new LongType(Long.TYPE));
        mapping.putType(Long.class, new LongType(Long.class));
        mapping.aliasFunction(new Function.Name("date('now')", true), Now.class);
    }

    @Override
    public boolean supportsGeneratedKeysInBatchUpdate() {
        return false;
    }

    @Override
    public boolean supportsAddingConstraint() {
        return false;
    }

    @Override
    public GeneratedColumnDefinition generatedColumnDefinition() {
        return this.autoIncrementColumn;
    }

    public LimitGenerator limitGenerator() {
        return new LimitGenerator();
    }

    @Override
    public Generator<Map<Expression<?>, Object>> upsertGenerator() {
        return new InsertOrReplace();
    }

    @Override
    public boolean supportsUpsert() {
        return false;
    }

    protected static class InsertOrReplace
    implements Generator<Map<Expression<?>, Object>> {
        protected InsertOrReplace() {
        }

        @Override
        public void write(final Output output, final Map<Expression<?>, Object> values2) {
            QueryBuilder qb = output.builder();
            Type type2 = ((Attribute)((Object)values2.keySet().iterator().next())).getDeclaringType();
            qb.keyword(Keyword.INSERT, Keyword.OR, Keyword.REPLACE, Keyword.INTO).tableNames(values2.keySet()).openParenthesis().commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    if (value instanceof Attribute) {
                        Attribute attribute = (Attribute)((Object)value);
                        if (attribute.isForeignKey() && attribute.getDeleteAction() == ReferentialAction.CASCADE) {
                            throw new IllegalStateException("replace would cause cascade");
                        }
                        qb.attribute(attribute);
                    }
                }
            }).closeParenthesis().space();
            String previousAlias = "prev";
            String newAlias = "next";
            qb.keyword(Keyword.SELECT).commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    qb.aliasAttribute("next", (Attribute)((Object)value));
                }
            }).keyword(Keyword.FROM).openParenthesis().keyword(Keyword.SELECT).commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression expression) {
                    qb.append("? ").keyword(Keyword.AS).append(expression.getName());
                    output.parameters().add(expression, values2.get(expression));
                }
            }).closeParenthesis().space().keyword(Keyword.AS).append("next").space().keyword(Keyword.LEFT, Keyword.JOIN).openParenthesis().keyword(Keyword.SELECT).commaSeparatedExpressions(values2.keySet()).keyword(Keyword.FROM).tableName(type2.getName()).closeParenthesis().space().keyword(Keyword.AS).append("prev").space().keyword(Keyword.ON).aliasAttribute("prev", type2.getSingleKeyAttribute()).append(" = ").aliasAttribute("next", type2.getSingleKeyAttribute());
        }
    }

    private static class LongType
    extends BasicType<Long>
    implements PrimitiveLongType {
        LongType(Class<Long> type2) {
            super(type2, 4);
        }

        @Override
        public Long fromResult(ResultSet results, int column) throws SQLException {
            return results.getLong(column);
        }

        @Override
        public Keyword getIdentifier() {
            return Keyword.INTEGER;
        }

        @Override
        public long readLong(ResultSet results, int column) throws SQLException {
            return results.getLong(column);
        }

        @Override
        public void writeLong(PreparedStatement statement, int index, long value) throws SQLException {
            statement.setLong(index, value);
        }
    }
}

