/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Cashier;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.util.CloseableIterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class CashierSyncAdapter
extends BaseConditionalSyncAdapter<Cashier, Long> {
    public CashierSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, "__all__", api, syncCycleId, feedback);
    }

    @Override
    public void updateObject(Cashier obj, JSONObject jsonobj) throws JSONException {
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setName(jsonobj.getString("name"));
        obj.setUserid(jsonobj.getString("userid"));
        obj.setPin(jsonobj.isNull("pin") ? "" : jsonobj.getString("pin"));
        obj.setJson_data(jsonobj.toString());
        obj.setActive(jsonobj.getBoolean("active"));
    }

    @Override
    public CloseableIterator<Cashier> runBatch(List<Long> ids) {
        return ((Result)this.store.select(Cashier.class, new QueryAttribute[0]).where(Cashier.SERVER_ID.in(ids)).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(Cashier.SERVER_ID).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "cashiers";
    }

    @Override
    protected String getUrl() {
        return this.api.organizerResourceUrl("pos/" + this.getResourceName());
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(Cashier obj) {
        return obj.getServer_id();
    }

    @Override
    Cashier newEmptyObject() {
        return new Cashier();
    }
}

