/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.util.ArrayFunctions;
import io.requery.util.function.Consumer;
import io.requery.util.function.Predicate;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ParameterInliner
implements Predicate<Object[]> {
    private static final Pattern questionMarkPattern = Pattern.compile("\\?");
    private String sql;
    private Object[] parameters;

    ParameterInliner(String sql, Object[] parameters2) {
        this.sql = sql;
        this.parameters = parameters2;
    }

    public Object[] parameters() {
        return this.parameters;
    }

    public String sql() {
        return this.sql;
    }

    ParameterInliner apply() {
        if (!this.test(this.parameters)) {
            return this;
        }
        ArrayList<Integer> indicesOfArguments = new ArrayList<Integer>(this.parameters.length);
        Matcher matcher = questionMarkPattern.matcher(this.sql);
        while (matcher.find()) {
            indicesOfArguments.add(matcher.start());
        }
        StringBuilder sb = new StringBuilder(this.sql);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = this.parameters.length - 1; i >= 0; --i) {
            Object parameter = this.parameters[i];
            if (indicesOfArguments.size() <= i) break;
            int index = (Integer)indicesOfArguments.get(i);
            if (parameter instanceof Iterable) {
                int sizeBefore = list.size();
                Iterable iterable = (Iterable)parameter;
                Consumer collector = ParameterInliner.collect(list);
                for (Object e : iterable) {
                    collector.accept(e);
                }
                this.expand(sb, index, list.size() - sizeBefore);
                continue;
            }
            if (parameter instanceof short[]) {
                short[] array = (short[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof int[]) {
                int[] array = (int[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof long[]) {
                long[] array = (long[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof float[]) {
                float[] array = (float[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof double[]) {
                double[] array = (double[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof boolean[]) {
                boolean[] array = (boolean[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            if (parameter instanceof Object[]) {
                Object[] array = (Object[])parameter;
                ArrayFunctions.forEach(array, ParameterInliner.collect(list));
                this.expand(sb, index, array.length);
                continue;
            }
            list.add(0, parameter);
        }
        this.sql = sb.toString();
        this.parameters = list.toArray();
        return this;
    }

    private static <T> Consumer<T> collect(final ArrayList<T> list) {
        return new Consumer<T>(){
            int index = 0;

            @Override
            public void accept(T t) {
                list.add(this.index++, t);
            }
        };
    }

    @Override
    public boolean test(Object[] value) {
        for (Object parameter : this.parameters) {
            if (!(parameter instanceof Iterable) && (parameter == null || !parameter.getClass().isArray())) continue;
            return true;
        }
        return false;
    }

    private void expand(StringBuilder sb, int index, int length) {
        StringBuilder replacement = new StringBuilder("(");
        for (int i = 0; i < length; ++i) {
            replacement.append("?");
            if (i + 1 >= length) continue;
            replacement.append(", ");
        }
        replacement.append(")");
        sb.replace(index, index + 1, replacement.toString());
    }
}

