/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.Migrations;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.sync.DownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseSingleObjectSyncAdapter<T extends RemoteObject & Persistable>
implements DownloadSyncAdapter {
    protected BlockingEntityStore<Persistable> store;
    protected PretixApi api;
    protected String eventSlug;
    protected String key;
    protected String syncCycleId;
    protected SyncManager.ProgressFeedback feedback;
    protected SyncManager.CanceledState canceledState;

    public BaseSingleObjectSyncAdapter(BlockingEntityStore<Persistable> store, String eventSlug, String key, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        this.store = store;
        this.api = api;
        this.eventSlug = eventSlug;
        this.key = key;
        this.syncCycleId = syncCycleId;
        this.feedback = feedback;
    }

    @Override
    public void setCancelState(SyncManager.CanceledState state) {
        this.canceledState = state;
    }

    @Override
    public void download() throws JSONException, ApiException {
        if (this.feedback != null) {
            this.feedback.postFeedback("Downloading " + this.getResourceName() + " [" + this.eventSlug + "] \u2026");
        }
        try {
            JSONObject data2 = this.downloadRawData();
            this.processData(data2);
        }
        catch (ResourceNotModified resourceNotModified) {
            // empty catch block
        }
    }

    abstract T getKnownObject();

    protected void processData(final JSONObject data2) {
        try {
            data2.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
            data2.put("__libpretixsync_syncCycleId", this.syncCycleId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.store.runInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Object known = BaseSingleObjectSyncAdapter.this.getKnownObject();
                JSONObject old = null;
                if (known != null) {
                    Object obj = known;
                    old = obj.getJSON();
                    if (!JSONUtils.similar(data2, (Object)old)) {
                        BaseSingleObjectSyncAdapter.this.updateObject(obj, data2);
                        BaseSingleObjectSyncAdapter.this.store.update(obj);
                    }
                } else {
                    Object obj = BaseSingleObjectSyncAdapter.this.newEmptyObject();
                    BaseSingleObjectSyncAdapter.this.updateObject(obj, data2);
                    BaseSingleObjectSyncAdapter.this.store.insert(obj);
                }
                return null;
            }
        });
    }

    public abstract void updateObject(T var1, JSONObject var2) throws JSONException;

    protected String getUrl() {
        return this.api.eventResourceUrl(this.eventSlug, this.getResourceName() + "/" + this.key);
    }

    protected JSONObject downloadRawData() throws ApiException, ResourceNotModified {
        return this.downloadPage(this.getUrl());
    }

    protected JSONObject downloadPage(String url2) throws ApiException, ResourceNotModified {
        return this.api.fetchResource(url2).getData();
    }

    abstract String getResourceName();

    abstract T newEmptyObject();
}

