/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.setup;

import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.setup.SetupBadRequestException;
import eu.pretix.libpretixsync.setup.SetupBadResponseException;
import eu.pretix.libpretixsync.setup.SetupException;
import eu.pretix.libpretixsync.setup.SetupResult;
import eu.pretix.libpretixsync.setup.SetupServerErrorException;
import eu.pretix.libpretixsync.utils.ErrorsKt;
import eu.pretix.libpretixsync.utils.NetUtils;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Leu/pretix/libpretixsync/setup/SetupManager;", "", "hardware_brand", "", "hardware_model", "os_name", "os_version", "software_brand", "software_version", "http_factory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Leu/pretix/libpretixsync/api/HttpClientFactory;)V", "initialize", "Leu/pretix/libpretixsync/setup/SetupResult;", "url", "token", "libpretixsync"})
public final class SetupManager {
    @NotNull
    private final String hardware_brand;
    @NotNull
    private final String hardware_model;
    @NotNull
    private final String os_name;
    @NotNull
    private final String os_version;
    @NotNull
    private final String software_brand;
    @NotNull
    private final String software_version;
    @NotNull
    private final HttpClientFactory http_factory;

    public SetupManager(@NotNull String hardware_brand, @NotNull String hardware_model, @NotNull String os_name, @NotNull String os_version, @NotNull String software_brand, @NotNull String software_version, @NotNull HttpClientFactory http_factory) {
        Intrinsics.checkNotNullParameter(hardware_brand, "hardware_brand");
        Intrinsics.checkNotNullParameter(hardware_model, "hardware_model");
        Intrinsics.checkNotNullParameter(os_name, "os_name");
        Intrinsics.checkNotNullParameter(os_version, "os_version");
        Intrinsics.checkNotNullParameter(software_brand, "software_brand");
        Intrinsics.checkNotNullParameter(software_version, "software_version");
        Intrinsics.checkNotNullParameter(http_factory, "http_factory");
        this.hardware_brand = hardware_brand;
        this.hardware_model = hardware_model;
        this.os_name = os_name;
        this.os_version = os_version;
        this.software_brand = software_brand;
        this.software_version = software_version;
        this.http_factory = http_factory;
    }

    @NotNull
    public final SetupResult initialize(@NotNull String url2, @NotNull String token) {
        Object object;
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(token, "token");
        OkHttpClient client = this.http_factory.buildClient(NetUtils.ignoreSSLforURL(url2));
        JSONObject apiBody = new JSONObject();
        apiBody.put("token", token);
        apiBody.put("hardware_brand", this.hardware_brand);
        apiBody.put("hardware_model", this.hardware_model);
        apiBody.put("os_name", this.os_name);
        apiBody.put("os_version", this.os_version);
        apiBody.put("software_brand", this.software_brand);
        apiBody.put("software_version", this.software_version);
        try {
            Request.Builder builder = new Request.Builder().url(url2 + "/api/v1/device/initialize");
            String string = apiBody.toString();
            Intrinsics.checkNotNullExpressionValue(string, "apiBody.toString()");
            object = string;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            object = builder.post(RequestBody.Companion.create$default(RequestBody.Companion, byArray, MediaType.Companion.parse("application/json"), 0, 0, 6, null)).build();
        }
        catch (IllegalArgumentException e) {
            throw new SetupException("Invalid URL entered");
        }
        Object request = object;
        Response response = null;
        response = client.newCall((Request)request).execute();
        ResponseBody responseBody = response.body();
        String body2 = responseBody != null ? responseBody.string() : null;
        int code = response.code();
        response.close();
        if (code >= 500) {
            throw new SetupServerErrorException(body2);
        }
        if (code == 400) {
            try {
                throw new SetupBadRequestException(ErrorsKt.flatJsonError(new JSONObject(body2)));
            }
            catch (JSONException e) {
                throw new SetupBadResponseException(body2);
            }
        }
        try {
            JSONObject respo = new JSONObject(body2);
            String gateName = respo.has("gate") && !respo.isNull("gate") ? respo.getJSONObject("gate").getString("name") : null;
            Long gateID = respo.has("gate") && !respo.isNull("gate") ? Long.valueOf(respo.getJSONObject("gate").getLong("id")) : null;
            String string = respo.getString("api_token");
            Intrinsics.checkNotNullExpressionValue(string, "respo.getString(\"api_token\")");
            String string2 = respo.getString("organizer");
            Intrinsics.checkNotNullExpressionValue(string2, "respo.getString(\"organizer\")");
            long l = respo.getLong("device_id");
            String string3 = respo.getString("unique_serial");
            Intrinsics.checkNotNullExpressionValue(string3, "respo.getString(\"unique_serial\")");
            String string4 = respo.optString("security_profile", "full");
            Intrinsics.checkNotNullExpressionValue(string4, "respo.optString(\"security_profile\", \"full\")");
            String string5 = respo.optString("name");
            Intrinsics.checkNotNullExpressionValue(string5, "respo.optString(\"name\")");
            return new SetupResult(url2, string, string2, l, string3, string4, string5, gateName, gateID);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new SetupBadResponseException(body2);
        }
    }
}

